package com.artfess.bpm.plugin.task.restful.plugin;

import java.util.List;

import javax.annotation.Resource;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.model.process.def.Restful;
import com.artfess.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.artfess.bpm.api.service.RestfulService;
import com.artfess.bpm.engine.identity.DefaultBpmIdentityService;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import com.artfess.bpm.plugin.task.restful.def.RestfulInvokePluginDef;
import com.artfess.uc.api.service.IUserService;

/**
 * restful接口调用插件
 * @author heyifan
 *
 */
public class RestfulInvokePlugin extends AbstractBpmTaskPlugin{
	@Resource
	BpmProcessInstanceManager bpmProcessInstanceManager;
	@Resource
	BpmDefinitionManager bpmDefinitionManager;
	@Resource
	IUserService userServiceImpl;
	@Resource
	DefaultBpmIdentityService bpmIdentityService;

	@Resource
	RestfulService restfulService;
	
	@Override
	public Void execute(BpmTaskPluginSession pluginSession,BpmTaskPluginDef pluginDef) {
		RestfulInvokePluginDef restfulPluginDef = (RestfulInvokePluginDef) pluginDef;
		List<Restful> restfuls = restfulPluginDef.getRestfulList();
		return BeanUtils.isNotEmpty(restfuls)?restfulService.taskPluginExecute(pluginSession, pluginDef,restfuls):null;
	}
	
}