package com.artfess.portal.kh.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 考核结果信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Data
@ApiModel(value="KhResult对象", description="考核结果信息")
public class KhResult extends BaseModel<KhResult> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "方案ID")
    @TableField("scheme_id_")
    private String schemeId;

    @ApiModelProperty(value = "计划ID")
    @TableField("plan_id_")
    private String planId;

    @ApiModelProperty(value = " 考核名称")
    @TableField("task_name_")
    private String taskName;

    @ApiModelProperty(value = " 考核开始时间")
    @TableField("start_date_")
    private LocalDate startDate;

    @ApiModelProperty(value = " 考核结束时间")
    @TableField("end_date_")
    private LocalDate endDate;

    @ApiModelProperty(value = "考核对象类型【字典】（ogn：单位，dept：部门，user：人员，post：岗位，other：其它）")
    @TableField("obj_type_")
    private String objType;

    @ApiModelProperty(value = "考核对象ID")
    @TableField("obj_id_")
    private String objId;

    @ApiModelProperty(value = "考核对象名称")
    @TableField("obj_name_")
    private String objName;

    @ApiModelProperty(value = "考核周期【字典】（1：周，2：月，3：季度，4：半年，5：年）")
    @TableField("period_")
    private String period;

    @ApiModelProperty(value = "实际考核日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "考核总分")
    @TableField("total_score_")
    private BigDecimal totalScore;

    @ApiModelProperty(value = "考核评级（优，良，中，差）")
    @TableField("level_")
    private String level;

    @ApiModelProperty(value = "实际考评人ID")
    @TableField("appraiser_id_")
    private String appraiserId;

    @ApiModelProperty(value = "实际考评人姓名")
    @TableField("appraiser_name_")
    private String appraiserName;

    @ApiModelProperty(value = "实际复核人ID")
    @TableField("review_id_")
    private String reviewId;

    @ApiModelProperty(value = "实际复核人姓名")
    @TableField("review_name_")
    private String reviewName;

    @ApiModelProperty(value = "状态【字典】(draft：未开始，edit：数据录入中，audit：审核中，review：复核中， end：已完成)")
    @TableField("status_")
    private String status;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "创建人单位")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgId;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "考核结果详情")
    @TableField(exist = false)
    private List<KhResultDetails> detailsList;

}
