package com.artfess.portal.kh.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.portal.kh.dao.KhSchemePlanDao;
import com.artfess.portal.kh.manager.KhAssessSchemeManager;
import com.artfess.portal.kh.manager.KhPlanObjectManager;
import com.artfess.portal.kh.manager.KhSchemeManager;
import com.artfess.portal.kh.manager.KhSchemePlanManager;
import com.artfess.portal.kh.model.KhAssessScheme;
import com.artfess.portal.kh.model.KhPlanObject;
import com.artfess.portal.kh.model.KhScheme;
import com.artfess.portal.kh.model.KhSchemePlan;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 考核计划信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Service
public class KhSchemePlanManagerImpl extends BaseManagerImpl<KhSchemePlanDao, KhSchemePlan> implements KhSchemePlanManager {

    @Autowired
    private KhPlanObjectManager planObjectManager;

    @Autowired
    private KhAssessSchemeManager assessSchemeManager;

    @Autowired
    private KhSchemeManager schemeManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(KhSchemePlan t) {
        t.setStatus("edit");
        boolean save = this.save(t);
        if(save) {
            processDetail(t);
            return save;
        }
        return false;
    }

    private void processDetail(KhSchemePlan t) {
        LambdaQueryWrapper<KhPlanObject> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(KhPlanObject::getPlanId, t.getId());
        planObjectManager.remove(lambdaQueryWrapper);
        if(CollectionUtils.isEmpty(t.getPlanObjectList())){
            return;
        }
        t.getPlanObjectList().forEach(detail -> {
            detail.setPlanId(t.getId());
        });
        planObjectManager.saveBatch(t.getPlanObjectList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(KhSchemePlan t) {
        boolean save = this.updateById(t);
        if(save) {
            processDetail(t);
            return save;
        }
        return false;
    }

    @Override
    public KhSchemePlan findById(String id) {
        KhSchemePlan KhSchemePlan = this.get(id);
        Assert.notNull(KhSchemePlan, "考核计划不存在");
        LambdaQueryWrapper<KhPlanObject> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(KhPlanObject::getPlanId, id);
        List<KhPlanObject> list = planObjectManager.list(lambdaQueryWrapper);
        KhSchemePlan.setPlanObjectList(list);
        if(!StringUtil.isEmpty(KhSchemePlan.getAssessId())) {
            KhAssessScheme khAssessScheme = assessSchemeManager.findById(KhSchemePlan.getAssessId());
            if(null != khAssessScheme) {
                KhSchemePlan.setAssessScheme(khAssessScheme);
            }
        }

        if(!StringUtil.isEmpty(KhSchemePlan.getSchemeId())) {
            KhScheme scheme = schemeManager.findById(KhSchemePlan.getSchemeId());
            if(null != scheme) {
                KhSchemePlan.setScheme(scheme);
            }
        }

        return KhSchemePlan;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStatus(List<String> ids, String status) {
        LambdaQueryWrapper<KhSchemePlan> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(KhSchemePlan::getId, ids);
        List<KhSchemePlan> list = this.list(lambdaQueryWrapper);
        list.forEach(KhSchemePlan -> {
            if(status.equals(KhSchemePlan.getStatus())) {
                throw new BaseException("当前计划状态与要修改状态一致，不能进行修改！");
            }
            KhSchemePlan.setStatus(status);
        });
        boolean b = this.updateBatchById(list);
        return b;
    }
}
