package com.artfess.portal.kh.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.portal.kh.manager.KhAssessSchemeManager;
import com.artfess.portal.kh.model.KhAssessScheme;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;

/**
 * 考核评级方案 前端控制器
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-02-20
 */
@Slf4j
@RestController
@Api(tags = "绩效考核-考核评级方案")
@RequestMapping("/kh/assess/scheme/")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class KhAssessSchemeController extends BaseController<KhAssessSchemeManager, KhAssessScheme> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) KhAssessScheme t) {
        boolean result = baseService.createInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>();
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) KhAssessScheme t) {
        boolean result = baseService.updateInfo(t);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>();
    }

    @Override
    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public KhAssessScheme getById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        return baseService.findById(id);
    }

    @GetMapping("/discard")
    @ApiOperation("废弃")
    public CommonResult<String> discard(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.updateStatus(Arrays.asList(ids), "-1");
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "废弃失败");
        }
        return new CommonResult<>();
    }

    @GetMapping("/startUse")
    @ApiOperation("启用")
    public CommonResult<String> startUse(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.updateStatus(Arrays.asList(ids), "1");
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "启用失败");
        }
        return new CommonResult<>();
    }
}
