/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.meta.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.table.colmap.SQLServerColumnMap;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.model.impl.DefaultTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class SQLServer2005TableMeta
extends BaseTableMeta {
    private String sqlPk = "SELECT c.COLUMN_NAME COLUMN_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS pk ,INFORMATION_SCHEMA.KEY_COLUMN_USAGE c WHERE \tpk.TABLE_NAME LIKE '%s' and\tCONSTRAINT_TYPE = 'PRIMARY KEY' and\tc.TABLE_NAME = pk.TABLE_NAME and\tc.CONSTRAINT_NAME = pk.CONSTRAINT_NAME ";
    private String sqlTableComment = "select top 1 cast((case b.minor_id when 0 then b.value else a.name end) as varchar) comment from sys.tables a left join sys.extended_properties b on a.object_id=b.major_id where a.type='U' and a.name='%s' ORDER BY b.minor_id asc";
    private String SQL_GET_COLUMNS = "SELECT a.name NAME,d.name TABLE_NAME,  case  when   exists(SELECT   1   FROM   sysobjects   where   xtype='PK'   and   name   in   (  SELECT   name   FROM   sysindexes   WHERE   indid   in(  SELECT   indid   FROM   sysindexkeys   WHERE   id   =   a.id   AND   colid=a.colid)))   then   1   else   0   end IS_PK,  b.name TYPENAME,a.length LENGTH, COLUMNPROPERTY(a.id,a.name,'PRECISION') PRECISION ,  isnull(COLUMNPROPERTY(a.id,a.name,'Scale'),0) SCALE,a.isnullable IS_NULLABLE,  isnull(cast(g.[value] as varchar(500)) ,A.name) DESCRIPTION  FROM   syscolumns   a  left   join   systypes   b   on   a.xusertype=b.xusertype  inner   join   sysobjects   d   on   a.id=d.id     and   d.xtype='U'   and     d.name<>'dtproperties'  left   join   syscomments   e   on   a.cdefault=e.id  left   join   sys.extended_properties   g   on   a.id=g.major_id   and   a.colid=g.minor_id  left   join   sys.extended_properties   f   on   d.id=f.major_id   and   f.minor_id=0 ";
    private String sqlAllTables = "select a.name name, cast(b.value as varchar(500)) comment from sys.tables a left join sys.extended_properties b on a.object_id=b.major_id where a.type='U'";

    @Override
    public Table getTableByName(String tableName) {
        Table model = this.getTable(tableName);
        List<Column> columnList = this.getColumnsByTableName(tableName);
        model.setColumnList(columnList);
        return model;
    }

    private String getPkColumn(String tableName) {
        String sql = String.format(this.sqlPk, tableName);
        Object rtn = this.jdbcTemplate.queryForObject(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int row) throws SQLException {
                return rs.getString("COLUMN_NAME");
            }
        });
        if (rtn == null) {
            return "";
        }
        return rtn.toString();
    }

    private Table getTable(final String tableName) {
        String sql = String.format(this.sqlTableComment, tableName);
        Table tableModel = (Table)this.jdbcTemplate.queryForObject(sql, (RowMapper)new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(tableName);
                tableModel.setComment(rs.getString("comment"));
                return tableModel;
            }
        });
        if (BeanUtils.isEmpty((Object)tableModel)) {
            tableModel = new DefaultTable();
        }
        tableModel.setTableName(tableName);
        return tableModel;
    }

    @Override
    public Map<String, String> getTablesByName(String tableName) {
        String sql = this.sqlAllTables;
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " and  lower(a.name) like '%" + tableName.toLowerCase() + "%'";
        }
        List list = this.jdbcTemplate.queryForList(sql);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comment");
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Map<String, String> getTablesByName(List<String> names) {
        StringBuffer sb = new StringBuffer();
        for (String name : names) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = this.sqlAllTables + " and  a.name in (" + sb.toString().toLowerCase() + ")";
        HashMap parameter = new HashMap();
        List list = this.jdbcTemplate.queryForList(sql, new Object[]{parameter, new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("name");
                String comments = rs.getString("comment");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", tableName);
                map.put("comments", comments);
                return map;
            }
        }});
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comments");
            map.put(name, comments);
        }
        return map;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = this.SQL_GET_COLUMNS + " where   d.name='" + tableName + "' order   by   a.id,a.colorder";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new SQLServerColumnMap());
        for (Column model : list) {
            model.setTableName(tableName);
        }
        return list;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = "";
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = this.SQL_GET_COLUMNS + " where   d.NAME IN (" + buf.toString() + ") order   by   a.id,a.colorder";
        List columnModels = this.jdbcTemplate.query(sql, (RowMapper)new SQLServerColumnMap());
        for (Column columnModel : columnModels) {
            String tableName = columnModel.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(columnModel);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(columnModel);
            map.put(tableName, cols);
        }
        return map;
    }

    @Override
    public List<Table> getTableModelByName(String tableName) throws Exception {
        String sql = this.sqlAllTables;
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND  LOWER(name) LIKE '%" + tableName.toLowerCase() + "%'";
        }
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(rs.getString("NAME"));
                tableModel.setComment(rs.getString("COMMENT"));
                return tableModel;
            }
        };
        List tableModels = this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tableModels) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tableModels) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tableModels;
    }

    @Override
    public String getAllTableSql() {
        return this.sqlAllTables;
    }

    @Override
    public List<Map<String, Object>> getTablesByNameIndex(String tableName) {
        return null;
    }
}

