/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.handler;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.artfess.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.engine.task.handler.AbstractTaskActionHandler;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.model.BpmExeStack;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TaskActionBackHandler
extends AbstractTaskActionHandler {
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmExeStackExecutorManager exeStrackExecutorManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmSignDataManager bpmSignDataManager;

    @Override
    public boolean isNeedCompleteTask() {
        return true;
    }

    @Override
    public void preActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        this.popStack(pluginSession);
    }

    private void popStack(TaskActionPluginSession pluginSession) throws Exception {
        UserTaskNodeDef backTargetNodeDef;
        NodeProperties nodeProperties;
        String backUserMode;
        BpmNodeDef bpmNodeDef;
        BpmExeStack stack;
        String currentToken;
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        String instId = cmd.getInstId();
        String destinationNode = cmd.getDestination();
        String destinationToken = "";
        String handMode = (String)cmd.getTransitVars("backHandMode");
        BpmTask task = (BpmTask)cmd.getTransitVars("bpmTask_");
        BpmDelegateTask bpmDelegateTask = this.natTaskService.getByTaskId(task.getId());
        String exeId = bpmDelegateTask.getExecutionId();
        task.setExecId(exeId);
        Object objToken = this.natProInstanceService.getVariable(exeId, "token_");
        String string = currentToken = objToken != null ? objToken.toString() : null;
        if (StringUtil.isEmpty((String)destinationNode)) {
            stack = this.bpmExeStackManager.getPrevStack(instId, task.getNodeId(), currentToken);
            destinationToken = currentToken;
        } else {
            stack = this.bpmExeStackManager.getStack(instId, destinationNode, currentToken);
            destinationToken = currentToken;
        }
        if (stack == null) {
            stack = this.bpmExeStackManager.getStack(instId, StringUtil.isEmpty((String)destinationNode) ? task.getNodeId() : destinationNode, null);
            destinationToken = "";
        }
        cmd.setDestinationToken(destinationToken);
        cmd.setDestination(destinationNode);
        if (BeanUtils.isNotEmpty((Object)((Object)stack)) && stack.getInterpose() == 0 && stack.getIsMulitiTask() == 0 && (cmd.getTransitVars("IsDoneUnused") == null || !((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue()) && (bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(stack.getPrcoDefId(), destinationNode)) instanceof UserTaskNodeDef && (StringUtil.isEmpty((String)(backUserMode = (nodeProperties = (backTargetNodeDef = (UserTaskNodeDef)bpmNodeDef).getLocalProperties()).getBackUserMode())) || backUserMode.equals("history"))) {
            List<BpmIdentity> identitys = this.exeStrackExecutorManager.getBpmIdentitysByStackId(stack.getId());
            cmd.addBpmIdentity(stack.getNodeId(), identitys);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)stack)) && stack.getInterpose() == 0 && cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue() && (bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(stack.getPrcoDefId(), destinationNode)) instanceof SignNodeDef) {
            List<BpmIdentity> signBpmIdentity = this.bpmSignDataManager.getByInstanIdAndNodeIdAndNo(instId, destinationNode);
            cmd.addBpmIdentity(destinationNode, signBpmIdentity);
            return;
        }
        this.bpmExeStackManager.popStack(instId, task.getNodeId(), currentToken, handMode, destinationNode, destinationToken);
    }

    @Override
    public void afterActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) {
    }

    @Override
    public ActionType getActionType() {
        return ActionType.BACK;
    }
}

