package com.artfess.query.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.string.StringPool;
import com.artfess.base.util.time.DateUtil;
import com.artfess.query.dao.BizQueryMyFollowDao;
import com.artfess.query.manager.BizQueryMyFollowManager;
import com.artfess.query.model.BizQueryMyFollow;
import com.artfess.query.model.BizQueryTagCase;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

/**
 * 我的关注记录表（BIZ_QUERY_MY_FOLLOW） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizQueryMyFollowManagerImpl extends BaseManagerImpl<BizQueryMyFollowDao, BizQueryMyFollow> implements BizQueryMyFollowManager {

    @Override
    @Transactional(readOnly=true)
    public PageList<BizQueryMyFollow> query(QueryFilter<BizQueryMyFollow> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class<BizQueryMyFollow> currentModelClass = currentModelClass();
        IPage<BizQueryMyFollow> result = this.baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        return new PageList<BizQueryMyFollow>(result);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveBizQueryMyFollow(BizQueryMyFollow bizQueryMyFollow){
        //查询当天是否有关注记录
        QueryWrapper<BizQueryMyFollow> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("USER_ID_",ContextUtil.getCurrentUser().getUserId());
        queryWrapper.eq("SEARCH_CONTENT_",bizQueryMyFollow.getSearchContent());
        Integer num =this.baseMapper.selectCount(queryWrapper);
        if(num == 0 ){
            IUser user= ContextUtil.getCurrentUser();
            bizQueryMyFollow.setUserId(user.getUserId());
            bizQueryMyFollow.setUserName(user.getUsername());
            bizQueryMyFollow.setSearchTime(LocalDateTime.now());
            this.save(bizQueryMyFollow);
            return bizQueryMyFollow.getId();
        }
        return null;
    }
}
