package com.artfess.query.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.query.model.BizQueryTag;

import java.util.List;
import java.util.Map;

/**
 * 搜索标签定义表（BIZ_QUERY_TAG） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
public interface BizQueryTagManager extends BaseManager<BizQueryTag> {

    /**
    * 首页统计查询
    * @param type 查询类型（1：个人，2：企业）
    * @param itemType  查询指标的类型
    * @Return: java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
    * @Author: chens
    * @Date: 2025/4/20 17:37
    */
    List<Map<String,Object>> countByType(Integer type,String itemType);
}
