package com.artfess.query.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.query.model.BizQueryResultCondition;
import com.artfess.query.vo.QueryParamVo;

import java.util.List;
import java.util.Map;

/**
 * 查询结果配置信息（BIZ_QUERY_RESULT_CONDITION） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
public interface BizQueryResultConditionManager extends BaseManager<BizQueryResultCondition> {

    /**
     * 根据查询条件 查询数据
     * @param queryParamVos
     * @return
     */
    Map<String,Object> queryDataList(QueryParamVo queryParamVos) throws Exception;

    /**
     * 根据ID查询详情
     * @param tableName 表
     * @param fieldName 查询字段 (例如:企业统一代码字段的名称:ENTERPRISE_TYSHXYDM_)
     * @param id 企业信用代码
     * @param tagId 查询标签ID
     * @return
     * @throws Exception
     */
    List<Map<String,Object>> queryDataById(String tagId,String tableName,String fieldName,String id) throws Exception;

    /**
     * 根据搜索标签查询详情页各个分类下面分类下的各表数据
     * @param tagId 搜索标签ID
     * @param groupName 分组名称
     * @param fieldName 查询字段 (例如:企业统一代码字段的名称:ENTERPRISE_TYSHXYDM_)
     * @param fieldValue 查询字段值
     * @return
     * @throws Exception
     */
    List<Map<String,Object>> queryGroupDataByTag(String tagId,String groupName, String fieldName,String fieldValue) throws Exception;

    /**
     * 查询详情页各个分类及分类表中数据量
     * @param tagId 标签ID
     * @param fieldName 关联字段的名称（例如：企业统一代码字段的名称：ENTERPRISE_TYSHXYDM_）
     * @param fieldVal 关联字段的值
     * @return
     * @throws Exception
     */
    Map<String,List<Map<String, Object>>> queryGroupCountByTag(String tagId,String fieldName,String fieldVal) throws Exception;
}
