package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizQueryResultMainManager;
import com.artfess.query.model.BizAdvanceQueryMouldConfig;
import com.artfess.query.model.BizQueryResultCondition;
import com.artfess.query.model.BizQueryResultMain;
import com.artfess.query.vo.BizQueryResultVo;
import com.artfess.query.vo.QueryParamVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 查询结果配置信息（BIZ_QUERY_RESULT_CONDITION） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-03-12
 */
@Api(tags = "企查查--查询结果配置信息主表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/resultMain/v1/")
public class BizQueryResultMainController extends BaseController<BizQueryResultMainManager, BizQueryResultMain> {

    @ApiOperation("批量保存查询结果配置信息表")
    @PostMapping("saveOrUpdateBatchResult")
    public CommonResult<String> saveOrUpdateBatchResult(@ApiParam(name = "model",value = "实体信息")
                                                      @RequestBody
                                                      @Validated({AddGroup.class}) BizQueryResultVo queryResultVo) throws Exception {
        boolean status = this.baseService.saveOrUpdateBatchResult(queryResultVo);
        return status ? CommonResult.success(null,"批量保存查询结果配置信息成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public BizQueryResultVo getById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {

        return baseService.getVoById(id);
    }

    @ApiOperation("根据标签查询对应结果配置信息")
    @PostMapping("qureyResultConfigByTag")
    public CommonResult<String> qureyResultConfigByTag(@RequestParam String tagId){
        List<BizQueryResultVo> list = this.baseService.qureyResultConfigByTag(tagId);
        List<Map<String,Object>> reList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(list)){
            Map<String,List<BizQueryResultVo>> map = list.stream().collect(Collectors.groupingBy(BizQueryResultVo::getGroupName));
            for (Map.Entry<String, List<BizQueryResultVo>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<BizQueryResultVo> value = entry.getValue();
                Map<String,Object> result = new HashMap<>();
                result.put("group",key);
                result.put("data",value);
                reList.add(result);
            }
        }
        return  CommonResult.success(reList,"获取成功！");
    }

}
