package com.artfess.query.manager.impl;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.query.dao.BizQueryResultConditionDao;
import com.artfess.query.dao.BizQueryResultMainDao;
import com.artfess.query.manager.BizQueryResultConditionManager;
import com.artfess.query.manager.BizQueryResultMainManager;
import com.artfess.query.model.BizQueryResultCondition;
import com.artfess.query.model.BizQueryResultMain;
import com.artfess.query.vo.BizQueryResultVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 查询结果配置信息（BIZ_QUERY_RESULT_CONDITION） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizQueryResultMainManagerImpl extends BaseManagerImpl<BizQueryResultMainDao, BizQueryResultMain> implements BizQueryResultMainManager {

    @Autowired
    BizQueryResultConditionManager queryResultConditionManager;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateBatchResult(BizQueryResultVo queryResultVo) throws Exception {
        if(BeanUtils.isNotEmpty(queryResultVo)){
           List<BizQueryResultCondition> list = queryResultVo.getQueryResultCondition();
            //验证字段不能出现重复
            List<String> fields=list.stream().map(t->t.getFieldName()).collect(Collectors.toList());
            List<String> disFields=fields.stream().distinct().collect(Collectors.toList());
            if(fields.size()!=disFields.size()){
                throw new ApplicationException("设置字段不能重复");
            }

           if(queryResultVo.getSn() == null){
               Map<String,Object> param = new HashMap<>();
               param.put("TAG_ID_",queryResultVo.getTagId());
               Integer sn = this.getNextSequence(param);
               queryResultVo.setSn(sn);
           }
           if(queryResultVo.getShowType()==3){
               queryResultVo.setGroupName("主表信息");
           }
           this.saveOrUpdate(queryResultVo);

           QueryWrapper<BizQueryResultCondition> queryWrapper = new QueryWrapper<>();
           queryWrapper.eq("MIAN_ID_", queryResultVo.getId());
           this.queryResultConditionManager.remove(queryWrapper);

           if(!CollectionUtils.isEmpty(list)){
               for(BizQueryResultCondition resultCondition : list){
                   resultCondition.setMianId(queryResultVo.getId());
                   if(resultCondition.getSn() == null){
                       Map<String,Object> param = new HashMap<>();
                       param.put("MIAN_ID_",queryResultVo.getId());
                       Integer sn = this.getNextSequence(param);
                       resultCondition.setSn(sn);
                   }
               }
               this.queryResultConditionManager.saveOrUpdateBatch(list);
           }
           return true;
        }
        return false;
    }

    @Override
    public BizQueryResultVo getVoById(String id) {
        Assert.hasText(id, "ID不能为空");
        BizQueryResultMain main= this.getById(id);
        if(main!=null) {
            QueryWrapper<BizQueryResultCondition> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("MIAN_ID_", id);
            queryWrapper.orderByAsc("SN_");
            List<BizQueryResultCondition> list = queryResultConditionManager.list(queryWrapper);
            BizQueryResultVo vo = new BizQueryResultVo();
            DmpBeanUtil.copyProperties(main, vo);
            vo.setQueryResultCondition(list);
            return vo;
        }
        return null;
    }

    @Override
    public List<BizQueryResultVo> qureyResultConfigByTag(String tagId) {
        Assert.hasText(tagId, "标签ID不能为空");
        List<BizQueryResultVo> queryResultVoList = new ArrayList<>();
        QueryWrapper<BizQueryResultMain> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("TAG_ID_", tagId);
        queryWrapper.orderByAsc("SN_");
        List<BizQueryResultMain> list = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(list)){
            List<String> mainIds = list.stream().filter(resultMain -> resultMain != null).map(BizQueryResultMain::getId).collect(Collectors.toList());
            QueryWrapper<BizQueryResultCondition> queryConditionWrapper = new QueryWrapper<>();
            queryConditionWrapper.in("MIAN_ID_", mainIds);
            queryConditionWrapper.orderByAsc("MIAN_ID_","SN_");
            List<BizQueryResultCondition> conditionList = queryResultConditionManager.list(queryConditionWrapper);
            Map<String,List<BizQueryResultCondition>> conditionMap= conditionList.stream().collect(Collectors.groupingBy(BizQueryResultCondition::getMianId));
            for(BizQueryResultMain main : list){
                BizQueryResultVo vo = new BizQueryResultVo();
                DmpBeanUtil.copyProperties(main, vo);
                List<BizQueryResultCondition> mainConditionList = conditionMap.get(main.getId());
                vo.setQueryResultCondition(mainConditionList);
                queryResultVoList.add(vo);
            }
            return queryResultVoList;
        }else{
            return Collections.emptyList();
        }

    }
}
