package com.artfess.dataShare.scheduler.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 定时任务作业  ---  配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-16
 */
@ApiModel(value="BizSchedulerJob对象", description="定时任务作业  ---  配置表")
@TableName("BIZ_SCHEDULER_JOB")
public class BizSchedulerJob extends AutoOrgFillModel<BizSchedulerJob> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "作业名称")
    @NotBlank(message = "请输入作业名称", groups = {AddGroup.class, UpdateGroup.class})
    @TableField("JOB_NAME_")
    private String jobName;

    @ApiModelProperty(value = "作业描述")
    @TableField("JOB_CONTENT_")
    private String jobContent;

    @NotNull(message = "请选择作业类别", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "作业类别（1：定时作业，2：非定时作业）")
    @TableField("JOB_TYPE_")
    private Integer jobType;

    @NotNull(message = "请选择作业任务类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "作业任务类型（1采集任务 2共享任务 3明细任务 4应用任务）")
    @TableField("JOB_TASK_TYPE_")
    private Integer jobTaskType;

    @ApiModelProperty(value = "定时作业时间Cron表达式")
    @TableField("JOB_CRON_")
    private String jobCron;


    @ApiModelProperty(value = "任务执行类路径")
    @TableField("JOB_CLASS_")
    private String jobClass;

    @ApiModelProperty(value = "任务执行参数配置")
    @TableField("JOB_PARAM_")
    private String jobParam;

    @NotNull(message = "请选择作业执行模式", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "作业执行模式（1Java 2Kettle 3shell 4平台ETL 5平台ODS抽取）")
    @TableField("JOB_TASK_MODE_")
    private Integer jobTaskMode;

    @ApiModelProperty(value = "任务运行状态( NONE：停止, NORMAL：运行,PAUSED：暂停,)")
    @TableField("JOB_STATUS_")
    private String jobStatus;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "资源项的调度配置表_ID")
    @TableField(exist = false)
    private String tId;

    @ApiModelProperty(value = "数据资源表_ID（数据表）")
    @TableField(exist = false)
    private String tableId;

    @ApiModelProperty(value = "数据资源名称")
    @TableField(exist = false)
    private String dataResourcesName;

    @ApiModelProperty(value = "Java作业任务配置")
    @TableField(exist = false)
    private BizSchedulerJavaTask schedulerJava;

    @ApiModelProperty(value = "Kettle作业任务配置")
    @TableField(exist = false)
    private BizSchedulerKettleTask schedulerKettle;

    @ApiModelProperty(value = "Shell作业任务配置 ")
    @TableField(exist = false)
    private BizSchedulerShellTask schedulerShell;

    @ApiModelProperty(value = "ETL作业任务配置")
    @TableField(exist = false)
    private BizSchedulerEtlTask schedulerEtl;

    @ApiModelProperty(value = "Ods采集作业任务配置")
    @TableField(exist = false)
    private BizSchedulerOdsTask schedulerOds;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobContent() {
        return jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }

    public Integer getJobType() {
        return jobType;
    }

    public void setJobType(Integer jobType) {
        this.jobType = jobType;
    }

    public Integer getJobTaskType() {
        return jobTaskType;
    }

    public void setJobTaskType(Integer jobTaskType) {
        this.jobTaskType = jobTaskType;
    }

    public String getJobCron() {
        return jobCron;
    }

    public void setJobCron(String jobCron) {
        this.jobCron = jobCron;
    }

    public String getJobClass() {
        return jobClass;
    }

    public void setJobClass(String jobClass) {
        this.jobClass = jobClass;
    }

    public String getJobParam() {
        return jobParam;
    }

    public void setJobParam(String jobParam) {
        this.jobParam = jobParam;
    }

    public Integer getJobTaskMode() {
        return jobTaskMode;
    }

    public void setJobTaskMode(Integer jobTaskMode) {
        this.jobTaskMode = jobTaskMode;
    }

    public String getJobStatus() {
        return jobStatus;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String gettId() {
        return tId;
    }

    public void settId(String tId) {
        this.tId = tId;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getDataResourcesName() {
        return dataResourcesName;
    }

    public void setDataResourcesName(String dataResourcesName) {
        this.dataResourcesName = dataResourcesName;
    }

    public BizSchedulerJavaTask getSchedulerJava() {
        return schedulerJava;
    }

    public void setSchedulerJava(BizSchedulerJavaTask schedulerJava) {
        this.schedulerJava = schedulerJava;
    }

    public BizSchedulerKettleTask getSchedulerKettle() {
        return schedulerKettle;
    }

    public void setSchedulerKettle(BizSchedulerKettleTask schedulerKettle) {
        this.schedulerKettle = schedulerKettle;
    }

    public BizSchedulerShellTask getSchedulerShell() {
        return schedulerShell;
    }

    public void setSchedulerShell(BizSchedulerShellTask schedulerShell) {
        this.schedulerShell = schedulerShell;
    }

    public BizSchedulerEtlTask getSchedulerEtl() {
        return schedulerEtl;
    }

    public void setSchedulerEtl(BizSchedulerEtlTask schedulerEtl) {
        this.schedulerEtl = schedulerEtl;
    }

    public BizSchedulerOdsTask getSchedulerOds() {
        return schedulerOds;
    }

    public void setSchedulerOds(BizSchedulerOdsTask schedulerOds) {
        this.schedulerOds = schedulerOds;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerJob{" +
            "id=" + id +
            ", jobName=" + jobName +
            ", jobContent=" + jobContent +
            ", jobType=" + jobType +
            ", jobTaskType=" + jobTaskType +
            ", jobCron=" + jobCron +
            ", jobClass=" + jobClass +
            ", jobParam=" + jobParam +
            ", jobTaskMode=" + jobTaskMode +
            ", jobStatus=" + jobStatus +
            ", sn=" + sn +
            ", isDele=" + isDele +
        "}";
    }
}
