package com.artfess.dataShare.factory;

import com.artfess.base.util.StringUtil;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.Map;

public class MySQLQueryData implements ITableQuery{

    @Override
    public QueryResultData queryTableData(QueryParam param) {

        QueryResultData resultData = new QueryResultData();
        JdbcTemplate jdbcTemplate = param.getJdbcTemplate();
        Map<String,String> paramMap= param.getParam();
        String tableName=param.getTableName();
        Integer pageNo=param.getPageNo();
        Integer pageSize=param.getPageSize();
        String order = param.getOrder();

        String querySql="select * from "+tableName+" where 1=1";
        String querySqlCount="select count(*) from "+tableName+" where 1=1";
        if(null!=paramMap) {
            for (String key : paramMap.keySet()) {
                querySql += " and " + key + " = '" + paramMap.get(key) + "'";
                querySqlCount += " and " + key + " = '" + paramMap.get(key) + "'";
            }
        }
        if(pageNo>0) {
            int total=jdbcTemplate.queryForObject(querySqlCount, Integer.class);
            resultData.setTotal(total);
        }
        if(StringUtil.isNotEmpty(order)){
            querySql+=" order by "+order;
        }else{
            querySql+=" order by create_time_ ";
        }
        if(pageNo>0) {
            querySql += " limit " + ((pageNo - 1) * pageSize) + "," + pageSize;
        }
        resultData.setData(jdbcTemplate.queryForList(querySql));
        resultData.setField(param.getField());

        return resultData;
    }
}
