package com.artfess.dataShare.doris.controller;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.constants.DataSourceConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.doris.mapper.UserDorisManager;
import com.artfess.dataShare.doris.model.UserDoris;
import com.artfess.dataShare.doris.vo.ChangeCompanyVo;
import com.artfess.poi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;


/*@RestController
@RequestMapping("/doris/test/v1/")
@Api(tags = "doris测试")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})*/
public class TestDorisController extends BaseController<UserDorisManager, UserDoris>{

    @Resource
    DatabaseContext databaseContext;

    @RequestMapping(value = "list", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "userData", httpMethod = "POST", notes = "获取bo定义列表")
    public CommonResult listJson() throws Exception {
        /*try (DatabaseSwitchResult setDataSource = databaseContext.setDataSource("doris")) {
            List<UserDoris> list = baseService.getAll();
            return new CommonResult(true, "查詢成功", list);
        } catch (Exception e) {
            e.printStackTrace();
        }*/

        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias("doris");

        //List<Map<String, Object>> list=template.queryForList("select * from user_data");
        List<UserDoris> list=template.queryForList("select * from user_data",UserDoris.class);
        return new CommonResult(true, "查詢成功", list);
    }


    @RequestMapping(value="import", method=RequestMethod.POST)
    @ApiOperation(value = "测试导入", httpMethod = "POST", notes = "测试导入")
    public CommonResult<String> importData(MultipartFile file){
        //roleService.importData(file);
        List<ChangeCompanyVo> list = ExcelUtil.readExcel(ChangeCompanyVo.class,file);
        if(BeanUtils.isNotEmpty(list)){
            for (ChangeCompanyVo roleVo : list) {
                System.out.println(roleVo);
            }
        }
        return new CommonResult<String>(true, "测试导入成功");
    }

}
