package com.artfess.dataShare.dataShare.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据共享管理--共享资源表字段信息（字段）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
@ApiModel(value="BizShareTableField对象", description="数据共享管理--共享资源表字段信息（字段）")
@TableName("BIZ_SHARE_TABLE_FIELD")
@Data
public class BizShareTableField extends AutoFillModel<BizShareTableField> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "共享数据资源表ID")
    @TableField("TABLE_ID")
    private String tableId;

    @ApiModelProperty(value = "共享数据资源名称")
    @TableField("RESOURCE_NAME_")
    private String resourceName;

    @ApiModelProperty(value = "共享数据资源编码")
    @TableField("RESOURCE_CODE_")
    private String resourceCode;

    @ApiModelProperty(value = "字段类别（1：管理字段，2：业务字段）")
    @TableField("FIELD_TYPE_")
    private String fieldType;

    @ApiModelProperty(value = "字段英文名（格式：F_字段编码）")
    @TableField("FIELD_CODE_")
    private String fieldCode;

    @ApiModelProperty(value = "字段名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "字段编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "字段描述")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "字段类型。string=字符串；number=数值；datetime=日期（长日期，通过显示格式来限制）")
    @TableField("DATA_TYPE_")
    private String dataType;

    @ApiModelProperty(value = "字段长度")
    @TableField("ATTR_LENGTH_")
    private Integer attrLength;

    @ApiModelProperty(value = "字段精度")
    @TableField("DECIMAL_LEN_")
    private Integer decimalLen;

    @ApiModelProperty(value = "字段默认值")
    @TableField("DEFAULT_VALUE_")
    private String defaultValue;

    @ApiModelProperty(value = "字段类型显示格式（yyyy-MM-dd，yyyy-MM-dd HH:mm:ss）")
    @TableField("FORMAT_")
    private String format;

    @ApiModelProperty(value = "字段取值的计量单位名称，无计量单位的字段取空字符串。")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "值范围描述")
    @TableField("FCHSC")
    private String fchsc;

    @ApiModelProperty(value = "是否是主键（0：否，1：是）")
    @TableField("IS_PK_")
    private String isPk;

    @ApiModelProperty(value = "是否加密（0：否，1：是）")
    @TableField("IS_ENCRYPT_")
    private String isEncrypt;

    @ApiModelProperty(value = "是否脱敏（0：否，1：是）")
    @TableField("IS_DESENSITIZE_")
    private String isDesensitize;

    @ApiModelProperty(value = "字段值类别（1:普通字段 2:枚举字典 3:多维字典项）")
    @TableField("FIELD_VALUE_TYPE")
    private Integer fieldValueType;

    @ApiModelProperty(value = "枚举和多维_CODE（参考枚举和多维定义的CODE值）")
    @TableField("DIMENSION_ID")
    private String dimensionId;

    @ApiModelProperty(value = "枚举和多维字典JSON串值（预处理写入）")
    @TableField("DIMENSION_JSON")
    private String dimensionJson;

    @ApiModelProperty(value = "字段创建状态（1：未创建 2：已创建）")
    @TableField("IS_CREATE_")
    private String isCreate;

    @ApiModelProperty(value = "操作状态（1：新增 2：修改）")
    @TableField("ADD_UPDATE")
    private Integer addUpdate;

    @ApiModelProperty(value = "创建的SQL语句")
    @TableField("FL_SQL")
    private String flSql;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1：已删除，0：未删除）")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele;
}
