package com.artfess.dataShare.dataShare.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据资产--共享需求方
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-04
 */
@ApiModel(value="BizShareConsumer对象", description="数据资产--共享需求方")
@TableName("BIZ_SHARE_CONSUMER")
@Data
public class BizShareConsumer extends AutoFillModel<BizShareConsumer> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "第三方调用者_编码【唯一值】")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "第三方调用者_名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "第三方调用者的系统名称")
    @TableField("APP_NAME_")
    private String appName;

    @ApiModelProperty(value = "第三方需求单位联系人")
    @TableField("CONTACT_PERSON_")
    private String contactPerson;

    @ApiModelProperty(value = "第三方需求单位联系人电话")
    @TableField("CONTACT_PHONE_")
    private String contactPhone;

    @ApiModelProperty(value = "是否开通API接口调用权限（0：否 【默认】 1：是）")
    @TableField("IS_OPEN_API_")
    private String isOpenApi;

    @ApiModelProperty(value = "接口访问keyID（AccessKeyId）【唯一值】")
    @TableField("ACCESS_KEY_")
    private String accessKey;

    @ApiModelProperty(value = "接口访问安全密钥（SecretAccessKey）【自动生成】")
    @TableField("SECRET_KEY_")
    private String secretKey;

    @ApiModelProperty(value = "当前TOKEN 信息")
    @TableField("TOKEN_INFO_")
    private String tokenInfo;

    @ApiModelProperty(value = "是否开通数据库共享权限（0：否【默认】  1：是）")
    @TableField("IS_OPEN_DB_")
    private String isOpenDb;

    @ApiModelProperty(value = "共享库类型（mysql,sqlserver,pgsql,）")
    @TableField("DATABASE_TYPE_")
    private String databaseType;

    @ApiModelProperty(value = "数据源ID")
    @TableField(exist = false)
    private String databaseId;

    @ApiModelProperty(value = "数据源别名")
    @TableField("DB_ALIAS_")
    private String dbAlias;

    @ApiModelProperty(value = "共享前置库实例名称")
    @TableField("DATABASE_NAME_")
    private String dataBaseName;

    @ApiModelProperty(value = "共享库地址")
    @TableField("DATABASE_URL_")
    private String databaseUrl;

    @ApiModelProperty(value = "共享库用户")
    @TableField("DATABASE_USER_")
    private String databaseUser;

    @ApiModelProperty(value = "共享库密码")
    @TableField("DATABASE_PWD_")
    private String databasePwd;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "关联数据共享门户系统登录账号")
    @TableField("LOGIN_USER_")
    private String loginUser;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    private String isDele;
}
