package com.artfess.dataShare.dataShare.manager.impl;

import cn.hutool.crypto.digest.DigestUtil;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.dataShare.dataShare.dao.BizShareConsumerDao;
import com.artfess.dataShare.dataShare.dto.ConsumerAuthDto;
import com.artfess.dataShare.dataShare.manager.BizShareAuthManager;
import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.util.MySQLUtils;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * 数据资产--共享需求方 服务实现类
 *
 * @author wubin
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-12-04
 */
@Service
public class BizShareConsumerManagerImpl extends BaseManagerImpl<BizShareConsumerDao, BizShareConsumer> implements BizShareConsumerManager {

    private static final String GETTOKEN_URL = "http://26.180.246.242:9157/biz/dataShare/shareConsumer/v1/getToken";

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private SysDataSourceManager dataSourceManager;

    @Resource
    private BizShareAuthManager authManager;

    @Resource
    private RedisUtil redisUtil;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean registerShareConsumer(BizShareConsumer shareConsumer) throws Exception {
        String account = ContextUtil.getCurrentUserAccount();
        if (StringUtils.isEmpty(shareConsumer.getCode())) {
            throw new ApplicationException("编码不能为空！");
        }
        if (StringUtils.isEmpty(shareConsumer.getName())) {
            throw new ApplicationException("名称不能为空！");
        }
        if (StringUtils.isEmpty(shareConsumer.getAppName())) {
            throw new ApplicationException("系统名称不能为空！");
        }
        int count = this.sameCountShareConsumer(shareConsumer.getCode(), null);
        if (count > 0) {
            throw new ApplicationException("需求方【" + shareConsumer.getName() + "】已有相同的编码【" + shareConsumer.getCode() + "】!");
        }
        int result = this.chackConsumer(account);
//        if(result > 0){
//            throw new ApplicationException("当前用户【" + account + "】已经注册了需求方【" + shareConsumer.getName() +"】！");
//        }
        shareConsumer.setIsDele("0");
//        shareConsumer.setDataBaseName("interchange_library");

        //开启API接口调用权限
        if ("1".equals(shareConsumer.getIsOpenApi())) {
            shareConsumer.setAccessKey(shareConsumer.getCode());
            String password = shareConsumer.getCode() + randomCode(6) + System.currentTimeMillis();
            shareConsumer.setSecretKey(password);
        }
        //创建数据库用户
        if ("1".equals(shareConsumer.getIsOpenDb())) {
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(shareConsumer.getDbAlias());
            //创建账号
            MySQLUtils.createDataUser(jdbcTemplate, shareConsumer.getDatabaseUser(), shareConsumer.getDatabasePwd());
        }
        shareConsumer.setLoginUser(ContextUtil.getCurrentUserAccount());

        return save(shareConsumer);
    }

    private int chackConsumer(String account) {
        return count(new LambdaQueryWrapper<BizShareConsumer>()
                .eq(BizShareConsumer::getIsDele, 0)
                .eq(BizShareConsumer::getLoginUser, account));
    }

    @Override
    public String getToken(String accessKey, String hashSecretKey) {
//        BizShareConsumer shareConsumer = new BizShareConsumer();
//        shareConsumer.setAccessKey(accessKey);
//        shareConsumer.setSecretKey(hashSecretKey);

//        HttpHeaders headers = new HttpHeaders();
//        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
//        HttpEntity<BizShareConsumer> request = new HttpEntity<>(shareConsumer,headers);
//        String token = restTemplate.postForObject(GETTOKEN_URL, request, String.class);
        if (StringUtils.isEmpty(accessKey)) {
            throw new ApplicationException("keyID不能为空！");
        }
        if (StringUtils.isEmpty(accessKey)) {
            throw new ApplicationException("密钥不能为空！");
        }
        BizShareConsumer shareConsumer = getByAccessKey(accessKey);
        if (shareConsumer == null) {
            throw new ApplicationException("keyID【" + accessKey + "】错误！");
        }
        String hashed = hashMd5(shareConsumer.getSecretKey());
        if (!hashSecretKey.equals(hashed)) {
            throw new ApplicationException("密钥匹配错误!");
        }
        String token = null;
        token = (String) redisUtil.get("api:token:" + accessKey);
        if (!StringUtils.isEmpty(token)) {
            return token;
        }
        try {
            String jsonConsumer = JsonUtil.toJson(shareConsumer);
            token = (shareConsumer.getSecretKey() + System.currentTimeMillis() + new Random().nextInt(1000));
            token = DigestUtil.md5Hex(token).replace("/", "*");
           /* MessageDigest md = MessageDigest.getInstance("md5");
            byte md5[] =  md.digest(token.getBytes());
            BASE64Encoder encoder = new BASE64Encoder();
            token = encoder.encode(md5).replace("/", "*");*/
            redisUtil.set("api:consumer:" + token, jsonConsumer, 24 * 60 * 60);
            redisUtil.set("api:token:" + accessKey, token, 24 * 60 * 60);
        } catch (Exception e) {
            throw new ApplicationException(e);
        }
        return token;
    }

    /**
     * md5加密
     *
     * @param str
     * @return
     */
    private String hashMd5(String str) {
        return DigestUtils.md5DigestAsHex(str.getBytes());
    }

    private BizShareConsumer getByAccessKey(String accessKey) {
        LambdaQueryWrapper<BizShareConsumer> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizShareConsumer::getAccessKey, accessKey);
        return this.baseMapper.selectOne(queryWrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(BizShareConsumer consumer) throws Exception {
        if ("1".equals(consumer.getIsOpenApi())) {
            consumer.setAccessKey(consumer.getCode());
            String password = consumer.getCode() + randomCode(6) + System.currentTimeMillis();
            consumer.setSecretKey(password);
        } else {
            consumer.setSecretKey(null);
            consumer.setAccessKey(null);
        }
        if ("1".equals(consumer.getIsOpenDb())) {
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(consumer.getDbAlias());
            if (checkDataUserIsExist(consumer.getDbAlias(), consumer.getDatabaseUser())) {
                //创建账号
                MySQLUtils.createDataUser(jdbcTemplate, consumer.getDatabaseUser(), consumer.getDatabasePwd());
            } else {
                //修改账号
                MySQLUtils.updateDateUser(jdbcTemplate, consumer.getDatabaseUser(), consumer.getDatabasePwd());
            }
        } else {
            consumer.setDbAlias(null);
            consumer.setDatabaseUrl(null);
            consumer.setDatabaseType(null);
            consumer.setDatabaseUrl(null);
            consumer.setDatabasePwd(null);
        }
        return updateById(consumer);
    }

    @Override
    public boolean checkDataUserIsExist(String dbAlias, String user) throws Exception {
        String sql = "SELECT COUNT(*) FROM mysql.user WHERE user = ?";
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);
        Integer count = jdbcTemplate.queryForObject(sql, new Object[]{user}, Integer.class);
        if (count > 0) {
            return false;
        }
        return true;
    }

    @Override
    public BizShareConsumer getInfoById(String id) {
        BizShareConsumer consumer = get(id);
        SysDataSource dataSource = dataSourceManager.getOne(new LambdaQueryWrapper<SysDataSource>()
                .eq(SysDataSource::getAlias, consumer.getDbAlias()));
        if (BeanUtils.isNotEmpty(dataSource)) {
            consumer.setDatabaseId(dataSource.getId());
        }
        return consumer;
    }

    @Override
    public PageList<BizShareConsumer> queryUnAuthByTable(QueryFilter<BizShareConsumer> queryFilter, String tableId) {
        IPage<BizShareConsumer> iPage = baseMapper.queryUnAuthByTable(convert2IPage(queryFilter.getPageBean())
                , convert2Wrapper(queryFilter, currentModelClass()), tableId);
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizShareConsumer> queryUnAuthByApi(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareConsumer> iPage = baseMapper.queryUnAuthByApi(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()), tableId, resourceId);
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizShareConsumer> queryUnAuthByFiles(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareConsumer> iPage = baseMapper.queryUnAuthByFiles(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()), tableId, resourceId);
        return new PageList<>(iPage);
    }

    @Override
    public PageList<ConsumerAuthDto> queryAuthByTable(QueryFilter<BizShareConsumer> queryFilter, String tableId) {
        IPage<BizShareAuth> iPage = baseMapper.queryTableAuth(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()),
                tableId);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        List<ConsumerAuthDto> resultList = new ArrayList<>();
        List<BizShareAuth> rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ConsumerAuthDto consumerAuthDto = new ConsumerAuthDto();
            BizShareConsumer consumer = get(auth.getMemberId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setConsumerName(consumer.getName());
            consumerAuthDto.setConsumerCode(consumer.getCode());
            resultList.add(consumerAuthDto);
        }
        PageList<ConsumerAuthDto> result = new PageList<>();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<ConsumerAuthDto> queryAuthByApi(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareAuth> iPage = baseMapper.queryAuthByApi(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()),
                tableId,
                resourceId);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        List<ConsumerAuthDto> resultList = new ArrayList<>();
        List<BizShareAuth> rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ConsumerAuthDto consumerAuthDto = new ConsumerAuthDto();
            BizShareConsumer consumer = get(auth.getMemberId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setConsumerName(consumer.getName());
            consumerAuthDto.setConsumerCode(consumer.getCode());
            resultList.add(consumerAuthDto);
        }
        PageList<ConsumerAuthDto> result = new PageList<>();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<ConsumerAuthDto> queryAuthByFiles(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareAuth> iPage = baseMapper.queryAuthByFiles(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()),
                tableId,
                resourceId);
        PageList<BizShareAuth> pageList = new PageList<>(iPage);
        List<ConsumerAuthDto> resultList = new ArrayList<>();
        List<BizShareAuth> rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ConsumerAuthDto consumerAuthDto = new ConsumerAuthDto();
            BizShareConsumer consumer = get(auth.getMemberId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setConsumerName(consumer.getName());
            consumerAuthDto.setConsumerCode(consumer.getCode());
            resultList.add(consumerAuthDto);
        }
        PageList<ConsumerAuthDto> result = new PageList<>();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeConsumer(String id) {
        BizShareConsumer consumer = get(id);
        try {
            if (!checkDataUserIsExist(consumer.getDbAlias(), consumer.getDatabaseUser())) {
                JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias(consumer.getDbAlias());
                //删除数据库用户
                MySQLUtils.dropDataUser(jdbcTemplate, consumer.getDatabaseUser());
            }
        } catch (Exception e) {
            throw new ApplicationException("数据库删除异常");
        }
        return removeById(id);
    }

    /**
     * 随机码
     *
     * @param place
     * @return
     */
    public static String randomCode(int place) {
        String base = "qwertyuioplkjhgfdsazxcvbnmQAZWSXEDCRFVTGBYHNUJMIKLOP0123456789";
        StringBuffer sb = new StringBuffer();
        Random rd = new Random();
        for (int i = 0; i < place; i++) {
            sb.append(base.charAt(rd.nextInt(base.length())));
        }
        return sb.toString();
    }

    private int sameCountShareConsumer(String code, String id) {
        LambdaQueryWrapper<BizShareConsumer> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizShareConsumer::getCode, code);
        queryWrapper.ne(!StringUtils.isEmpty(id), BizShareConsumer::getId, id);
        return this.baseMapper.selectCount(queryWrapper);
    }
}
