package com.artfess.dataShare.dataShare.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.base.manager.BaseManager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 数据资源--文件共享信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-29
 */
public interface BizShareFilesManager extends BaseManager<BizShareFiles> {

    /**
     * 保存文件配置信息
     * @param file
     * @return
     */
    boolean saveInfo(BizShareFiles file);

    /**
     * 修改文件配置信息
     * @param file
     * @return
     */
    boolean updateInfo(BizShareFiles file);

    /**
     * 资源文件上传
     * @param response
     * @param request
     * @param id
     * @return
     */
    boolean uploadFile(HttpServletResponse response, HttpServletRequest request, String id);

    /**
     * 资源文件下载
     * @param response
     * @param request
     * @param id
     */
    void downloadFile(HttpServletResponse response, HttpServletRequest request, String id) throws IOException;

    /**
     * 通过表ID查询文件详情
     * @param tableId
     * @return
     */
    List<BizShareFiles> queryByTableId(String tableId);

    /**
     * 授权查询-通过目录分页查询接口
     * @param queryFilter
     * @param catalogId
     * @return
     */
    PageList<BizShareFiles> queryPageByCatalog(QueryFilter<BizShareFiles> queryFilter, String catalogId,String consumerId);

    /**
     * 获取文件详情
     * @param id
     * @return
     */
    BizShareFiles getInfo(String id);

    /**
     * 根据id删除-同时删除上传的文件
     * @param id
     * @return
     */
    boolean removeFilesById(String id);

    PageList<BizShareFiles> queryPage(QueryFilter<BizShareFiles> queryFilter);

    /**
     * 批量-根据id删除-同时删除上传的文件
     * @param ids
     * @return
     */
    boolean removeBatch(List<String> ids);
}
