package com.artfess.dataShare.dataShare.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.dto.ConsumerAuthDto;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.base.manager.BaseManager;

/**
 * 数据资产--共享需求方 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-04
 */
public interface BizShareConsumerManager extends BaseManager<BizShareConsumer> {

    /**
     * 注册第三方消费者
     * @param shareConsumer
     * @return
     */
    boolean registerShareConsumer(BizShareConsumer shareConsumer) throws Exception;

    /**
     * 第三方消费者获取token
     * @param accessKey
     * @param hashSecretKey
     * @return
     */
    String getToken(String accessKey, String hashSecretKey);

    /**
     * 修改消费者
     * @param consumer
     * @return
     */
    boolean updateInfo(BizShareConsumer consumer) throws Exception;

    /**
     * 验证数据库用户是否存在
     * @param dbAlias
     * @param user
     * @return
     */
    boolean checkDataUserIsExist(String dbAlias, String user) throws Exception;

    /**
     * 查看需求方详情
     * @param id
     * @return
     */
    BizShareConsumer getInfoById(String id);

    /**
     * 查询未开通表权限得需求方
     * @param queryFilter
     * @return
     */
    PageList<BizShareConsumer> queryUnAuthByTable(QueryFilter<BizShareConsumer> queryFilter,String tableId);

    /**
     * 查询未开通接口权限的需求方
     * @param queryFilter
     * @param tableId
     * @param resourceId
     * @return
     */
    PageList<BizShareConsumer> queryUnAuthByApi(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId);

    /**
     * 查询未开通文件权限的需求方
     * @param queryFilter
     * @param tableId
     * @param resourceId
     * @return
     */
    PageList<BizShareConsumer> queryUnAuthByFiles(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId);

    /**
     * 查询已开通表权限的需求方
     * @param queryFilter
     * @param tableId
     * @return
     */
    PageList<ConsumerAuthDto> queryAuthByTable(QueryFilter<BizShareConsumer> queryFilter, String tableId);

    /**
     * 已授权-查询已开通接口权限的需求方
     * @param queryFilter
     * @param tableId
     * @return
     */
    PageList<ConsumerAuthDto> queryAuthByApi(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId);

    /**
     * 已授权-查询已开通文件权限的需求方
     * @param queryFilter
     * @param tableId
     * @param resourceId
     * @return
     */
    PageList<ConsumerAuthDto> queryAuthByFiles(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId);

    /**
     * 删除需求方 同时删除数据库中的用户
     * @param id
     * @return
     */
    boolean removeConsumer(String id);
}
