package com.artfess.dataShare.dataShare.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.dto.ApiAuthDto;
import com.artfess.dataShare.dataShare.dto.FilesAuthDto;
import com.artfess.dataShare.dataShare.dto.TableAuthDto;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.vo.ConsumerAuthVo;

import java.util.List;

/**
 * 数据资产--共享资源授权 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-30
 */
public interface BizShareAuthManager extends BaseManager<BizShareAuth> {

    /**
     * 开通权限
     * @param list
     * @return
     */
    boolean auth(List<BizShareAuth> list) throws Exception;

    /**
     * 撤销权限
     * @param ids
     * @return
     */
    boolean revokeAuth(List<String> ids) throws Exception;

    /**
     * 开通表查询权限
     * @param list
     * @return
     */
    boolean tableAuth(List<BizShareAuth> list) throws Exception;

    /**
     * 分页查询-需求方授权列表
     * @param queryFilter
     * @return
     */
    PageList<ConsumerAuthVo> queryPageByConsumer(QueryFilter<BizShareAuth> queryFilter, String consumerId, String resourceType);

    /**
     * 分页查询-资源授权
     * @param queryFilter
     * @param resourceId
     * @param resourceType
     * @return
     */
    PageList<ConsumerAuthVo> queryPageByResource(QueryFilter<BizShareAuth> queryFilter, String resourceId, String resourceType);

    /**
     * 查询-已给-需求方授权的表资源
     * @param queryFilter
     * @param consumerId
     * @return
     */
    PageList<TableAuthDto> queryTableAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId);

    /**
     * 分页查询-已给需求方授权的接口
     * @param queryFilter
     * @param consumerId
     * @return
     */
    PageList<ApiAuthDto> queryApiAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId);

    /**
     * 分页查询-已给需求方授权的文件资源
     * @param queryFilter
     * @param consumerId
     * @return
     */
    PageList<FilesAuthDto> queryFilesAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId);
}
