package com.artfess.dataShare.dataShare.interceptor;

import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;
import com.artfess.dataShare.dataShare.manager.BizShareFileLogManager;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.model.BizShareFileLog;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;

public class DownloadFileInterceptor extends HandlerInterceptorAdapter {

    private ThreadLocal<Long> startTime = new ThreadLocal<>();

    @Resource
    private BizShareFileLogManager fileLogManager;

    @Resource
    private BizShareFilesManager filesManager;

    @Resource
    private BizShareTableManager tableManager;

    @Resource
    private BizShareConsumerManager consumerManager;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        startTime.set(System.currentTimeMillis());
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Map<String, String[]> parameterMap = request.getParameterMap();
        String[] values = parameterMap.get("id");
        String fileId = values[0];
        BizShareFiles file = filesManager.get(fileId);
        BizShareTable table = tableManager.get(file.getTableId());
        BizShareConsumer consumer = consumerManager.getOne(new LambdaQueryWrapper<BizShareConsumer>()
                .eq(BizShareConsumer::getLoginUser, ContextUtil.getCurrentUserAccount()));
        BizShareFileLog fileLog = new BizShareFileLog();
        fileLog.setMemberId(consumer.getId());
        fileLog.setMemberCode(consumer.getCode());
        fileLog.setMemberName(consumer.getName());
        fileLog.setAppName(consumer.getAppName());
        fileLog.setTableId(table.getId());
        fileLog.setResourceCode(table.getCode());
        fileLog.setResourceName(table.getName());
        fileLog.setFileId(file.getId());
        fileLog.setFileName(file.getFileName());
        fileLog.setFilePath(file.getFilePath());
        fileLog.setRequestIp(getClientIpAddress(request));
        Instant instant = Instant.ofEpochMilli(startTime.get());
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        fileLog.setRequestTime(localDateTime);
        fileLogManager.save(fileLog);
    }

    private String getClientIpAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        return ipAddress;
    }
}
