package com.artfess.dataShare.dataShare.dao;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 数据资产--共享资源授权 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-30
 */
public interface BizShareAuthDao extends BaseMapper<BizShareAuth> {

    IPage<BizShareAuth> queryPageByConsumer(IPage<BizShareAuth> convert2IPage,
                                               @Param(Constants.WRAPPER) Wrapper<BizShareAuth> convert2Wrapper,
                                               @Param("consumerId") String consumerId,
                                               @Param("resourceType") String resourceType);

    IPage<BizShareAuth> queryPageByResource(IPage<BizShareAuth> convert2IPage,
                                               @Param(Constants.WRAPPER) Wrapper<BizShareAuth> convert2Wrapper,
                                               @Param("resourceId") String resourceId,
                                               @Param("resourceType") String resourceType);

    IPage<BizShareAuth> queryTableAuth(IPage<BizShareAuth> convert2IPage,
                                       @Param(Constants.WRAPPER) Wrapper<BizShareAuth> convert2Wrapper,
                                       @Param("consumerId") String consumerId);

    IPage<BizShareAuth> queryApiAuth(IPage<BizShareAuth> convert2IPage,
                                     @Param(Constants.WRAPPER) Wrapper<BizShareAuth> convert2Wrapper,
                                     @Param("consumerId") String consumerId);

    IPage<BizShareAuth> queryFilesAuth(IPage<BizShareAuth> convert2IPage,
                                       @Param(Constants.WRAPPER) Wrapper<BizShareAuth> convert2Wrapper,
                                       @Param("consumerId") String consumerId);
}
