package com.artfess.dataShare.dataShare.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataShare.model.BizShareTableField;
import com.artfess.dataShare.dataShare.manager.BizShareTableFieldManager;
import org.springframework.web.multipart.MultipartFile;

import java.sql.SQLException;
import java.util.List;

/**
 * 数据共享管理--共享资源表字段信息（字段） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
@RestController
@RequestMapping("/biz/dataShare/shareTableField/v1/")
@Api(tags = "数据共享管理--共享资源表字段信息（字段）")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizShareTableFieldController extends BaseController<BizShareTableFieldManager, BizShareTableField> {

    @PostMapping("saveInfoBatch")
    @ApiOperation("批量添加实体的接口")
    public CommonResult<String> saveInfoBatch(@RequestBody BizShareTable table) throws SQLException {
        boolean result = baseService.saveInfoBatch(table);
        return result ? CommonResult.success(null,"创建成功！") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @PostMapping("/importFile")
    @ApiOperation(value = "导入数据字段信息", httpMethod = "POST", notes = "导入数据字段信息")
    public CommonResult<String> importFile(@RequestParam(value = "file", required = true) MultipartFile file, String tableId) throws Exception {
        baseService.importFile(file,tableId);
        return new CommonResult<String>(true, "导入数据字段信息成功");
    }

    @PostMapping("/saveOrUpdateFields")
    @ApiOperation(value = "修改发布后的表字段信息-同时要修改实体表", httpMethod = "POST", notes = "修改发布后的表字段信息-同时要修改实体表")
    public CommonResult<String> saveOrUpdateFields(@RequestBody List<BizShareTableField> field) throws Exception {
        this.baseService.saveOrUpdateFields(field);
        return new CommonResult<String>(true, "修改成功");
    }
}
