package com.artfess.dataShare.dataShare.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.dataShare.dto.TableAuthDto;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * 数据共享管理--共享资源表管理 （元数据信息+TABLE信息） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
@RestController
@RequestMapping("/biz/dataShare/shareTable/v1/")
@Api(tags = "数据共享管理--共享资源表管理 （元数据信息+TABLE信息）")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizShareTableController extends BaseController<BizShareTableManager, BizShareTable> {

    @PostMapping("deploy")
    @ApiOperation("资源发布上线")
    public CommonResult<String> deploy(@RequestParam("id") String id){
        boolean result = baseService.deploy(id);
        return result ? CommonResult.success(null,"发布成功！") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@Validated({AddGroup.class}) @RequestBody BizShareTable table) {
        boolean result = baseService.saveInfo(table);
        return result ? CommonResult.success(null,"创建成功！") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @PostMapping("/queryPage")
    @ApiOperation("分页查询表详情")
    public PageList<BizShareTable> queryPage(@RequestBody QueryFilter<BizShareTable> queryFilter){
        PageList<BizShareTable> pageList = baseService.queryPage(queryFilter);
        return pageList;
    }

    @PostMapping("/queryTableField")
    @ApiOperation("查看表字段")
    public CommonResult<BizShareTable> queryTableField(@RequestParam String id){
        BizShareTable table = baseService.queryTableField(id);
        return CommonResult.success(table,"查询成功");
    }

    @PostMapping("/queryTableInfo")
    @ApiOperation("查看表详情")
    public CommonResult<BizShareTable> queryTableInfo(@RequestParam String id){
        BizShareTable table = baseService.queryTableInfo(id);
        return CommonResult.success(table,"查询成功");
    }

    @PostMapping("/queryAuthPage")
    @ApiOperation("查询-未给-需求方授权的资源")
    public PageList<BizShareTable> queryAuthPage(@RequestBody QueryFilter<BizShareTable> queryFilter,
                                                      @RequestParam("consumerId") String consumerId){
        PageList<BizShareTable> pageList = baseService.queryAuthPage(queryFilter,consumerId);
        return pageList;
    }

    @DeleteMapping("/removeTable/{id}")
    @ApiOperation("删除表和字段-如果表已经创建同步删除实体表")
    public CommonResult<String> delete(@PathVariable("id") String id) throws Exception {
        boolean result = baseService.removeTable(id);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @DeleteMapping("/removeTableBatch")
    @ApiOperation("批量删除表和字段-如果表已经创建同步删除实体表")
    public CommonResult<String> removeBatch(@ApiParam(name = "ids", value = "实体集合") @RequestParam List<String> ids) throws Exception {
        boolean result = baseService.removeBatch(ids);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @GetMapping("/queryTableSql")
    @ApiOperation("获取建表sql")
    public CommonResult<String> queryTableSql(@RequestParam("id") String id){
        String sql = baseService.queryTableSql(id);
        return CommonResult.success(sql,"获取成功");
    }

    @PostMapping(value = "checkTableExists", produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "验证表是否已经存在", httpMethod = "POST", notes = "验证表是否已经存在")
    public CommonResult<String> checkTableExists(@ApiParam(name = "tableId", value = "表ID", required = false, defaultValue = "") @RequestParam String tableId,
                                                 @ApiParam(name = "dbAlias",value = "数据库别名") @RequestParam String dbAlias,
                                                 @ApiParam(name = "tableNameEn", value = "表英文名") @RequestParam String tableNameEn) throws Exception {
        boolean isExists = baseService.checkTableExists(tableId,dbAlias,tableNameEn);
        if(isExists){
            return new CommonResult<>(false,"表"+tableNameEn+"已经存在，请更换表名");
        }
        return new CommonResult<>(true,"可以使用表名");
    }

    @PostMapping(value = "checkPhysicsTableExists", produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "验证物理表是否已经存在", httpMethod = "POST", notes = "验证表是否已经存在")
    public CommonResult<String> checkPhysicsTableExists(@ApiParam(name = "tableId", value = "表ID") @RequestParam String tableId,
                                                        @ApiParam(name = "tableNameEn", value = "表英文名") @RequestParam String tableNameEn) throws Exception {
        boolean isExists = baseService.checkPhysicsTableExists(tableId,tableNameEn);
        if(isExists){
            return new CommonResult<>(true,"验证成功，可以发布");
        }
        return new CommonResult<>(false,"表"+tableNameEn+"不存在！");
    }

    @RequestMapping(value = "deployHaveTable", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "已有表发布", httpMethod = "POST", notes = "已有表发布")
    public CommonResult<String> deployHaveTable(@ApiParam(name = "tableId", value = "数据表ID") @RequestParam String tableId) throws Exception {
        baseService.deployHaveTable(tableId);
        return new CommonResult<>(true,"已有表发布成功");
    }

    @RequestMapping(value = "deployDotHaveTable", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "未有表发布", httpMethod = "POST", notes = "未有表发布")
    public CommonResult<String> deployDotHaveTable(@ApiParam(name = "tableId", value = "数据表ID") @RequestParam String tableId,
                                                   @ApiParam(name = "tableSql", value = "建表语句") @RequestParam String tableSql) throws Exception {
        baseService.deployDotHaveTable(tableId,tableSql);
        return new CommonResult<>(true,"未有表发布成功");
    }

    @RequestMapping(value = "updateCatalog", method = RequestMethod.PUT, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改表资源目录", httpMethod = "PUT", notes = "修改表资源目录")
    public CommonResult<String> updateCatalog(@RequestParam String[] ids,@RequestParam String catalogId){
        boolean result = baseService.updateCatalog(ids,catalogId);
        if (result){
            return new CommonResult<>(true,"操作成功");
        }
        return new CommonResult<>(false,"操作失败");
    }
}
