package com.artfess.dataShare.dataShare.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataShare.model.BizShareApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * 数据资源--文件共享信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-29
 */
@RestController
@RequestMapping("/biz/dataShare/shareFiles/v1/")
@Api(tags = "数据资源--文件共享信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizShareFilesController extends BaseController<BizShareFilesManager, BizShareFiles> {

    @PostMapping("saveInfo")
    @ApiOperation("保存文件配置信息")
    public CommonResult<String> saveInfo(@RequestBody BizShareFiles file){
        boolean result = baseService.saveInfo(file);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizShareFiles> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizShareFiles> queryFilter) {
        PageList<BizShareFiles> pageList = baseService.queryPage(queryFilter);
        return pageList;
    }

    @Override
    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public BizShareFiles getById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        BizShareFiles files = baseService.getInfo(id);
        return files;
    }

    @PutMapping("updateInfo")
    @ApiOperation("修改文件配置信息")
    public CommonResult<String> updateInfo(@RequestBody BizShareFiles file){
        boolean result = baseService.updateInfo(file);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("uploadFile")
    @ApiOperation("资源文件上传")
    public CommonResult<String> uploadFile(HttpServletResponse response, HttpServletRequest request, @RequestParam("id") String id){
        boolean result = baseService.uploadFile(response,request,id);
        return result ? CommonResult.success(null,"资源上传成功！") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @GetMapping("downloadFile")
    @ApiOperation("资源文件下载")
    public void downloadFile(HttpServletResponse response, HttpServletRequest request,@RequestParam("id") String id) throws IOException {
        baseService.downloadFile(response,request,id);
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除-同时删除上传的文件")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.removeFilesById(id);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @DeleteMapping("/removeBatch")
    @ApiOperation("批量-根据id删除-同时删除上传的文件")
    public CommonResult<String> removeBatch(@RequestParam String... ids){
        boolean result = baseService.removeBatch(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("queryPageByCatalog")
    @ApiOperation("授权查询-通过目录分页查询接口")
    public PageList<BizShareFiles> queryPageByCatalog(@RequestBody QueryFilter<BizShareFiles> queryFilter,
                                                      @RequestParam("catalogId") String catalogId,
                                                      @RequestParam("consumerId") String consumerId){
        PageList<BizShareFiles> pageList = baseService.queryPageByCatalog(queryFilter, catalogId,consumerId);
        return pageList;
    }
}
