package com.artfess.dataShare.dataResource.ods.vo;

import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;

/**
 * 数据资源-- 引用/复制创建ods层的其他表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2025-1-5
 */
@ApiModel(value="CopyTableVo对象", description="数据资源-- 引用/复制创建ods层的其他表")
@Data
public class CopyTableVo extends BizClusterTable {

    @ApiModelProperty(value = "源表ID")
    private String sourceTableId;

    public static BizClusterTable parse(CopyTableVo roleVo){
        BizClusterTable vo = new BizClusterTable();
        try {
            BeanUtils.copyNotNullProperties(vo,roleVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return vo;
    }
}
