package com.artfess.dataShare.dataResource.ods.vo;

import com.artfess.base.entity.AutoOrgFillModel;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 数据资源-- ODS数据资源项实体表信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-22
 */
@ApiModel(value="BizOdsTable对象", description="数据资源-- ODS数据资源项实体表信息")
public class BizOdsTableVo extends AutoOrgFillModel<BizOdsTableVo> {

    private static final long serialVersionUID = 1L;

    private String id;

    @ApiModelProperty(value = "数据资源ID")
    private String mouldId;

    @ApiModelProperty(value = "数据资源编码")
    private String mouldCode;

    @ApiModelProperty(value = "资源项名称")
    private String name;

    @ApiModelProperty(value = "资源项编码")
    private String code;

    @ApiModelProperty(value = "资源项描述")
    private String desc;

    @ApiModelProperty(value = "数据库表名")
    private String tableName;

    @ApiModelProperty(value = "是否生成表（0：否，1：是）")
    private Integer isCreateTable;

    @ApiModelProperty(value = "排序")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    private String tenantId;

    @ApiModelProperty(value = "字段")
    private List<BizOdsField> fieldList;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMouldId() {
        return mouldId;
    }

    public void setMouldId(String mouldId) {
        this.mouldId = mouldId;
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Integer getIsCreateTable() {
        return isCreateTable;
    }

    public void setIsCreateTable(Integer isCreateTable) {
        this.isCreateTable = isCreateTable;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public List<BizOdsField> getFieldList() {
        return fieldList;
    }

    public void setFieldList(List<BizOdsField> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizOdsTable{" +
            "id=" + id +
            ", mouldId=" + mouldId +
            ", mouldCode=" + mouldCode +
            ", name=" + name +
            ", code=" + code +
            ", desc=" + desc +
            ", tableName=" + tableName +
            ", isCreateTable=" + isCreateTable +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
