package com.artfess.dataShare.dataResource.ods.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.dataResource.ods.dao.BizSchedulerCollectDayDao;
import com.artfess.dataShare.dataResource.ods.manager.BizSchedulerCollectDayManager;
import com.artfess.dataShare.dataResource.ods.model.BizSchedulerCollectDay;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 数据采集每日数据采集量汇总统计记录表（每日采集量统计） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-18
 */
@Service
public class BizSchedulerCollectDayManagerImpl extends BaseManagerImpl<BizSchedulerCollectDayDao, BizSchedulerCollectDay> implements BizSchedulerCollectDayManager {

    @Resource
    JdbcTemplate jdbcTemplate;

    @Transactional(rollbackFor = Exception.class )
    public void calcSchedulerCollectDay() throws Exception{
        //删除当天的汇总数据
        jdbcTemplate.execute("delete from BIZ_SCHEDULER_COLLECT_DAY where count_date_=date_format(now(),'%Y%m%d')");

        String sql="insert into BIZ_SCHEDULER_COLLECT_DAY(id_,company_name_,sys_name_,sys_code_,name_,code_,table_name_," +
                "total_num_,add_num_,update_num_,del_num_,create_time_,count_date_)" +
                "select concat(date_format(now(),'%Y%m%d'),UCASE(left(replace(UUID(),'-',''),12))),t.* from (select company_name_,sys_name_,sys_code_,name_,code_,table_name_,sum(total_num_) total_num_,\n" +
                "sum(add_num_) add_num_,\n" +
                "sum(update_num_) update_num_,\n" +
                "sum(del_num_) del_num_,now(),date_format(now(),'%Y%m%d')\n" +
                "from BIZ_SCHEDULER_COLLECT_TIMES where date_format(create_time_,'%Y%m%d')=date_format(now(),'%Y%m%d')\n" +
                "group by company_name_,sys_name_,sys_code_,name_,code_,table_name_\n" +
                ") t";//
        //JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
        jdbcTemplate.execute(sql);
    }

}
