package com.artfess.dataShare.dataResource.dw.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.dw.dao.BizDwCatalogsDao;
import com.artfess.dataShare.dataResource.dw.manager.BizDwCatalogsManager;
import com.artfess.dataShare.dataResource.dw.model.BizDwCatalogs;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 数据资产--Dw资源目录
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2024-11-13
 */
@Service
public class BizDwCatalogsManagerImpl extends BaseManagerImpl<BizDwCatalogsDao, BizDwCatalogs> implements BizDwCatalogsManager {

    @Autowired
    private SysTypeManager sysTypeManager;

    @Override
    public List<BizDwCatalogs> getTree(BizDwCatalogs entity) {
        QueryWrapper<BizDwCatalogs> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }
        queryWrapper.orderByAsc("sn_");
        List<BizDwCatalogs> sysList = this.baseMapper.selectList(queryWrapper);
        List<BizDwCatalogs> tree = BeanUtils.listToTree(sysList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public CommonResult<String> moveTree(String id, String parentId) throws Exception {
        Assert.hasText(id, "ids不能为空");
        Assert.hasText(parentId, "treeId不能为空");
        if(StringUtil.isEmpty(id)||StringUtil.isEmpty(parentId)){
            throw new RequiredException("移动节点或目标节点id不能为空！");
        }
        BizDwCatalogs rel = this.get(id);
        if(BeanUtils.isEmpty(rel)){
            throw new RequiredException("根据移动节点id【"+id+"】未找到对应节点！");
        }
        if(parentId.equals(rel.getParentId())){
            return new CommonResult<String>(true, "节点【"+rel.getName()+"】已经是其子节点，不需要更新！", "");
        }
        BizDwCatalogs parentRel = this.get(parentId);
        List<BizDwCatalogs> childrens = this.getByParentId(parentRel.getId());
        for (BizDwCatalogs userRel : childrens) {
            if(!userRel.getId().equals(rel.getId())&&userRel.getCode().equals(rel.getCode())&&
                    userRel.getName().equals(rel.getName())){
                throw new RequiredException("节点【"+parentRel.getName()+"】下已存在节点【"+rel.getName()+"】，不能添加多个!");
            }
        }
        if(BeanUtils.isEmpty(parentRel)){
            throw new RequiredException("根据目标节点id【"+parentId+"】未找到对应节点！");
        }else{
            rel.setFullId(parentRel.getFullId()+"/"+rel.getId());
        }
        rel.setParentId(parentId);
        this.update(rel);
        updatePortalSysType(id,parentId);
        updateChildrenRel(rel);
        return new CommonResult<String>(true, "更新目录线成功！", "");
    }

    /**
     * 递归更新子的节点th
     * @throws Exception
     */
    @Transactional(rollbackFor = Exception.class )
    public void updateChildrenRel(BizDwCatalogs parentRel) throws Exception{
        List<BizDwCatalogs> childrens = this.getByParentId(parentRel.getId());
        for (BizDwCatalogs rel : childrens) {
            rel.setFullId(parentRel.getFullId()+"/"+rel.getId());
            this.update(rel);
            updatePortalSysType(rel.getId(),parentRel.getId());
            updateChildrenRel(rel);
        }
    }

    public List<BizDwCatalogs> getByParentId(String parentId) throws Exception {
        if(StringUtil.isEmpty(parentId)){
            throw new RequiredException("父节点id“parentId”不能为空！");
        }
        QueryWrapper<BizDwCatalogs> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("parent_id_",parentId);
        return this.list(queryWrapper);
    }



    @Transactional(rollbackFor = Exception.class )
    public void updatePortalSysType(String id,String parentId) throws Exception {
        SysType sysType=sysTypeManager.getById(id);
        sysType.setParentId(parentId);
        //SysType sysTypeTemp = sysTypeManager.getInitSysType(0,parentId);
        SysType parent=this.sysTypeManager.get(parentId);
        String path=parent.getPath();
        sysType.setPath(path +id +".");
        sysTypeManager.update(sysType);
    }
}
