package com.artfess.dataShare.dataResource.app.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataResource.app.model.BizAppDataCleanLogs;
import com.artfess.dataShare.dataResource.app.manager.BizAppDataCleanLogsManager;

/**
 * APP层数据清洗治理每次日志记录表 ( 由Dolphin任务执行后写入) 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-27
 */
@RestController
@RequestMapping("/bizAppData/cleanLogs/v1/")
@Api(tags = "数据应用层表--APP层数据清洗治理每次日志记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAppDataCleanLogsController extends BaseController<BizAppDataCleanLogsManager, BizAppDataCleanLogs> {

}
