package com.artfess.dataShare.dataCollect.vo;

import com.artfess.base.typehandle.ShortTypeHandle;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;


public class BizDataSourceVo {

    @ApiModelProperty(name="id", notes="主键")
    protected String id;

    @ApiModelProperty("名称")
    protected String name;

    @ApiModelProperty("别名")
    protected String alias;

    @ApiModelProperty("驱动类路径")
    protected String classPath;/*类名*/

    @ApiModelProperty("数据源类型")
    protected String dbType;

    @ApiModelProperty("Json存储配置")
    protected String settingJson;

    @ApiModelProperty("在启动时，启动连接池，并添加到spring容器中管理。")
    protected Boolean initOnStart;

    @ApiModelProperty("是否生效")
    protected Boolean enabled;

    @ApiModelProperty("初始化方法，有些可以不填写")
    protected String initMethod;

    @ApiModelProperty("关闭数据源的时候应该调用的方法，可不填 ")
    protected String closeMethod;

    @ApiModelProperty(value = "数据源类型（1：汇聚交换，2：ODS，3：DW，4：共享）")
    private Integer datasourcesType;

    /**
     * id
     * @return  the id
     * @since   1.0.0
     */

    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * name
     * @return  the name
     * @since   1.0.0
     */

    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * alias
     * @return  the alias
     * @since   1.0.0
     */

    public String getAlias() {
        return alias;
    }

    /**
     * @param alias the alias to set
     */
    public void setAlias(String alias) {
        this.alias = alias;
    }

    /**
     * dbType
     * @return  the dbType
     * @since   1.0.0
     */

    public String getDbType() {
        return dbType;
    }

    /**
     * @param dbType the dbType to set
     */
    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    /**
     * settingJson
     * @return  the settingJson
     * @since   1.0.0
     */

    public String getSettingJson() {
        return settingJson;
    }

    /**
     * @param settingJson the settingJson to set
     */
    public void setSettingJson(String settingJson) {
        this.settingJson = settingJson;
    }

    /**
     * initOnStart
     * @return  the initOnStart
     * @since   1.0.0
     */

    public Boolean getInitOnStart() {
        return initOnStart;
    }

    /**
     * @param initOnStart the initOnStart to set
     */
    public void setInitOnStart(Boolean initOnStart) {
        this.initOnStart = initOnStart;
    }

    /**
     * enabled
     * @return  the enabled
     * @since   1.0.0
     */

    public Boolean getEnabled() {
        return enabled;
    }

    /**
     * @param enabled the enabled to set
     */
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * initMethod
     * @return  the initMethod
     * @since   1.0.0
     */

    public String getInitMethod() {
        return initMethod;
    }

    /**
     * @param initMethod the initMethod to set
     */
    public void setInitMethod(String initMethod) {
        this.initMethod = initMethod;
    }

    /**
     * closeMethod
     * @return  the closeMethod
     * @since   1.0.0
     */

    public String getCloseMethod() {
        return closeMethod;
    }

    /**
     * @param closeMethod the closeMethod to set
     */
    public void setCloseMethod(String closeMethod) {
        this.closeMethod = closeMethod;
    }

    /**
     * classPath
     * @return  the classPath
     * @since   1.0.0
     */

    public String getClassPath() {
        return classPath;
    }



    /**
     * @param classPath the classPath to set
     */
    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public Integer getDatasourcesType() {
        return datasourcesType;
    }

    public void setDatasourcesType(Integer datasourcesType) {
        this.datasourcesType = datasourcesType;
    }

    /**
     * @see Object#toString()
     */
    public String toString()
    {
        return new ToStringBuilder(this)
                .append("name", this.name)
                .append("alias", this.alias)
                .append("dsId", this.dbType)
                .append("settingJson", this.settingJson)
                .append("initOnStart", this.initOnStart)
                .append("enabled", this.enabled)
                .append("initMethod", this.initMethod)
                .append("closeMethod", this.closeMethod)
                .append("classPath", this.classPath)
                .toString();
    }
}