package com.artfess.dataShare.dataCollect.vo;

import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.poi.annotation.Excel;
import io.swagger.annotations.ApiModel;

import java.lang.reflect.InvocationTargetException;

/**
 * 数据汇聚字段信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-08
 */
@ApiModel(value="BizClusterField对象", description="数据汇聚字段信息")
public class BizClusterFieldVo {

    //序号	*字段英文名	*字段中文名	*字段描述（字段备注释义）	*数据类型	数据长度	数据精度	是否主键	是否允许为空	是否存储加密	是否脱敏	*字段类别	备注

    @Excel(name = "所属表ID")
    private String tableId;

    @Excel(name ="*字段英文名")
    private String fieldName;

    @Excel(name ="*字段中文名")
    private String name;

    @Excel(name ="*字段编码")
    private String code;

    @Excel(name ="*字段描述（字段备注释义）")
    private String desc;

    @Excel(name ="*数据类型",readConverterExp = "varchar=字符串,number=数字,date=日期,text=大文本")
    private String dataType;

    @Excel(name ="字段默认值")
    private String defaultValue;

    @Excel(name ="数据长度")
    private Integer attrLength;

    @Excel(name ="是否主键",readConverterExp = "0=否,1=是")
    private String isPk;

    @Excel(name ="是否允许为空",readConverterExp = "0=否,1=是")
    private String isRequired;

    @Excel(name ="是否存储加密",readConverterExp = "0=否,1=是")
    private String isEncrypt;

    @Excel(name ="是否脱敏",readConverterExp = "0=否,1=是")
    private String isDesensitize;

    @Excel(name ="数据精度")
    private Integer decimalLen;

    @Excel(name ="*字段类别",readConverterExp = "1=管理字段,2=业务字段")
    private String fieldType;

    @Excel(name ="序号")
    private Integer sn;

    @Excel(name ="备注")
    private String remark;

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getAttrLength() {
        return attrLength;
    }

    public void setAttrLength(Integer attrLength) {
        this.attrLength = attrLength;
    }

    public String getIsPk() {
        return isPk;
    }

    public void setIsPk(String isPk) {
        this.isPk = isPk;
    }

    public String getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(String isRequired) {
        this.isRequired = isRequired;
    }

    public String getIsEncrypt() {
        return isEncrypt;
    }

    public void setIsEncrypt(String isEncrypt) {
        this.isEncrypt = isEncrypt;
    }

    public String getIsDesensitize() {
        return isDesensitize;
    }

    public void setIsDesensitize(String isDesensitize) {
        this.isDesensitize = isDesensitize;
    }

    public Integer getDecimalLen() {
        return decimalLen;
    }

    public void setDecimalLen(Integer decimalLen) {
        this.decimalLen = decimalLen;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public static BizClusterTableField parse(BizClusterFieldVo roleVo){
        BizClusterTableField vo = new BizClusterTableField();
        try {
            BeanUtils.copyNotNullProperties(vo,roleVo);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public String toString() {
        return "BizClusterField{" +
            "tableId=" + tableId +
            ", fieldName=" + fieldName +
            ", name=" + name +
            ", code=" + code +
            ", desc=" + desc +
            ", dataType=" + dataType +
            ", defaultValue=" + defaultValue +
            ", attrLength=" + attrLength +
            ", isPk=" + isPk +
            ", isRequired=" + isRequired +
            ", isEncrypt=" + isEncrypt +
            ", isDesensitize=" + isDesensitize +
            ", decimalLen=" + decimalLen +
            ", sn=" + sn +
            ", fieldType=" + fieldType +
        "}";
    }
}
