package com.artfess.dataShare.dataCollect.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据汇聚字段信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-10
 */
@ApiModel(value="BizClusterTableField对象", description="数据汇聚字段信息")
public class BizClusterTableField extends AutoOrgFillModel<BizClusterTableField> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键字段名称
     */
    public static String PK_NAME = "ID_";

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据资源表ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "数据资源项名称")
    @TableField("MOULD_NAME_")
    private String mouldName;

    @ApiModelProperty(value = "数据资源项编码")
    @TableField("MOULD_CODE_")
    private String mouldCode;

    @ApiModelProperty(value = "字段英文名（格式：F_字段编码）")
    @TableField("FIELD_NAME_")
    private String fieldName;

    @ApiModelProperty(value = "字段名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "字段编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "字段描述")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "字段类型。string=字符串；number=数值；datetime=日期（长日期，通过显示格式来限制）")
    @TableField("DATA_TYPE_")
    private String dataType;

    @ApiModelProperty(value = "字段默认值")
    @TableField("DEFAULT_VALUE_")
    private String defaultValue;

    @ApiModelProperty(value = "字段类型显示格式（yyyy-MM-dd，yyyy-MM-dd HH:mm:ss）")
    @TableField("FORMAT_")
    private String format;

    @ApiModelProperty(value = "字段长度")
    @TableField("ATTR_LENGTH_")
    private Integer attrLength;

    @ApiModelProperty(value = "是否主键（0：否，1：是）")
    @TableField("IS_PK_")
    private String isPk;

    @ApiModelProperty(value = "是否必填（0：否，1：是）")
    @TableField("IS_REQUIRED_")
    private String isRequired;

    @ApiModelProperty(value = "是否加密（0：否，1：是）")
    @TableField("IS_ENCRYPT_")
    private String isEncrypt;

    @ApiModelProperty(value = "是否脱敏（0：否，1：是）")
    @TableField("IS_DESENSITIZE_")
    private String isDesensitize;

    @ApiModelProperty(value = "字段精度")
    @TableField("DECIMAL_LEN_")
    private Integer decimalLen;

    @ApiModelProperty(value = "字段类别（1：管理字段，2：业务字段）")
    @TableField("FIELD_TYPE_")
    private String fieldType;

    @ApiModelProperty(value = "字段创建状态（1：未创建 2：已创建）")
    @TableField("IS_CREATE_")
    private String isCreate;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1：已删除，0：未删除）")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getMouldName() {
        return mouldName;
    }

    public void setMouldName(String mouldName) {
        this.mouldName = mouldName;
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Integer getAttrLength() {
        return attrLength;
    }

    public void setAttrLength(Integer attrLength) {
        this.attrLength = attrLength;
    }

    public String getIsPk() {
        return isPk;
    }

    public void setIsPk(String isPk) {
        this.isPk = isPk;
    }

    public String getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(String isRequired) {
        this.isRequired = isRequired;
    }

    public String getIsEncrypt() {
        return isEncrypt;
    }

    public void setIsEncrypt(String isEncrypt) {
        this.isEncrypt = isEncrypt;
    }

    public String getIsDesensitize() {
        return isDesensitize;
    }

    public void setIsDesensitize(String isDesensitize) {
        this.isDesensitize = isDesensitize;
    }

    public Integer getDecimalLen() {
        return decimalLen;
    }

    public void setDecimalLen(Integer decimalLen) {
        this.decimalLen = decimalLen;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getIsCreate() {
        return isCreate;
    }

    public void setIsCreate(String isCreate) {
        this.isCreate = isCreate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizClusterTableField{" +
            "id=" + id +
            ", tableId=" + tableId +
            ", mouldName=" + mouldName +
            ", mouldCode=" + mouldCode +
            ", fieldName=" + fieldName +
            ", name=" + name +
            ", code=" + code +
            ", desc=" + desc +
            ", dataType=" + dataType +
            ", defaultValue=" + defaultValue +
            ", format=" + format +
            ", attrLength=" + attrLength +
            ", isPk=" + isPk +
            ", isRequired=" + isRequired +
            ", isEncrypt=" + isEncrypt +
            ", isDesensitize=" + isDesensitize +
            ", decimalLen=" + decimalLen +
            ", fieldType=" + fieldType +
            ", isCreate=" + isCreate +
            ", remark=" + remark +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
