package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataCollect.dao.BizClusterTableFieldDao;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableFieldManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataCollect.vo.BizClusterFieldVo;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import com.artfess.dataShare.util.Constants;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 数据汇聚字段信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-10
 */
@Service
public class BizClusterTableFieldManagerImpl extends BaseManagerImpl<BizClusterTableFieldDao, BizClusterTableField> implements BizClusterTableFieldManager {

    @Resource
    BizClusterTableManager tableManager;
    @Resource
    BizClusterInfoModeManager infoModeManager;
    @Resource
    private BizClusterTableFieldManager fieldManager;

    @Transactional(rollbackFor = Exception.class )
    public void export(MultipartFile file, String tableId) throws Exception{
        BizClusterTable table = tableManager.get(tableId);
        if(null==table){
            throw new ApplicationException("未查询到实体表");
        }
        String tableName=table.getTableNameCh();
        ExcelTool<BizClusterFieldVo> util = new ExcelTool<>(BizClusterFieldVo.class);
        List<BizClusterFieldVo> list = util.importExcel(file.getInputStream(),2,2);
        list = list.stream().filter(vo->StringUtil.isNotEmpty(vo.getFieldName())).collect(Collectors.toList());
        List<BizClusterTableField> oldFields = fieldManager.queryFieldByTableId(tableId);
        Set<String> manageFields = new HashSet<>();
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0){
            manageFields = oldFields.stream()
                    .filter(entity -> "1".equals(entity.getFieldType()))
                    .map(entity -> entity.getFieldName())
                    .collect(Collectors.toSet());
        }

        for(int i=1;i<list.size();i++){
            BizClusterFieldVo vo = list.get(i);
            if(StringUtil.isEmpty(vo.getFieldName())){
                continue;
            }
            if (manageFields.contains(vo.getFieldName())){
                continue;
            }
            if(checkExistsField(tableId,vo.getFieldName())){
                throw new BaseException("表【"+table.getTableNameCh()+"中存在字段("+vo.getFieldName()+")】请修改后在导入");
            }
        }
        List<String> disFieldList=list.stream().map(p->p.getFieldName()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<list.size()){
            throw new BaseException("表【"+table.getTableNameCh()+"中存在重复字段名请修改后在导入");
        }
        for(int i=1;i<list.size();i++){
            BizClusterFieldVo vo = list.get(i);
            if(StringUtil.isEmpty(vo.getFieldName())){
                continue;
            }
            if (manageFields.contains(vo.getFieldName())){
                continue;
            }
            //System.out.println(vo);

            BizClusterTableField field = vo.parse(vo);
            //field.setIsRequired("0");
            field.setTableId(tableId);
            field.setCode(field.getFieldName());
            field.setMouldCode(table.getCode());
            field.setMouldName(table.getTableNameCh());
            field.setIsDele("0");
            //addColumn(tableName,field);
            //initBoFormField(field,tableId);
            this.create(field);
            //System.out.println(field);
        }
        //String alertFieSQl="ALTER TABLE `w_jyjh` ADD COLUMN `name` varchar(32) NOT NULL";
    }

    public boolean checkExistsField(String tableId,String fieldName){
        QueryWrapper<BizClusterTableField> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_ID_",tableId);
        queryWrapper.eq("FIELD_NAME_",fieldName);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    public boolean checkExistsField(String tableId,String fieldName,String id){
        QueryWrapper<BizClusterTableField> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_ID_",tableId);
        queryWrapper.eq("FIELD_NAME_",fieldName);
        queryWrapper.ne("ID_",id);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    public List<BizClusterTableField> queryFieldByTableId(String tableId){
        QueryWrapper<BizClusterTableField> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("table_id_",tableId);
        queryWrapper.orderByAsc("sn_");
        return this.list(queryWrapper);
    }

    @Transactional(rollbackFor = Exception.class )
    public void saveTableField(TableDetailVo vo){
        BizClusterTable table = vo.getTable();
        List<BizClusterTableField> listField=vo.getFieldList();
        List<String> disFieldList=listField.stream().map(p->p.getFieldName()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<listField.size()){
            throw new BaseException("表【"+table.getTableNameCh()+"中存在重复字段名请修改后在保存");
        }
        if(StringUtil.isEmpty(table.getId())){
            tableManager.create(table);
        }else{
            tableManager.update(table);
        }
        for(BizClusterTableField item : listField){
            if(StringUtil.isEmpty(item.getId())){
                if(checkExistsField(table.getTableNameEn(),item.getFieldName())){
                    throw new BaseException("表【"+table.getTableNameCh()+"中存在字段("+item.getFieldName()+")】请修改后在导入");
                }
            }else{
                if(checkExistsField(table.getTableNameEn(),item.getFieldName(),item.getId())){
                    throw new BaseException("表【"+table.getTableNameCh()+"中存在字段("+item.getFieldName()+")】请修改后在导入");
                }
            }
            item.setTableId(table.getId());
        }
        this.saveOrUpdateBatch(listField);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdateFields(List<BizClusterTableField> fields) throws Exception {
        if(fields.size()==0){
            throw  new ApplicationException("没有修改的字段");
        }
        String tableId = fields.get(0).getTableId();
        BizClusterTable table = tableManager.get(tableId);
        List<String> disFieldList=fields.stream().map(p->p.getCode()).distinct().collect(Collectors.toList());
        if(disFieldList.size()<fields.size()){
            throw new BaseException("表【"+table.getTableNameCh()+"中存在重复字段名请修改后在保存");
        }
        BizClusterInfoMode infoMode=infoModeManager.getById(table.getClusterId());
        String tableName=table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(infoMode.getDatabaseAlias());

        for(BizClusterTableField field : fields){
            field.setIsCreate("1");
            //创建字段
            Integer attrLength=field.getAttrLength()==null ? 0 : field.getAttrLength();
            Integer decimalLen=field.getDecimalLen()==null ? 4 : field.getDecimalLen();
            field.setDecimalLen(decimalLen);
            field.setFieldName(field.getCode());
            //新镇字段
            if(StringUtil.isEmpty(field.getId())){
                if(field.getSn()==null){
                    Map<String,Object> map=new HashMap<>();
                    map.put("TABLE_ID_",tableId);
                    field.setSn(this.getNextSequence(map));
                }

                field.setMouldCode(fields.get(0).getMouldCode());
                field.setMouldName(fields.get(0).getMouldName());
                String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+field.getFieldName()+"` "+ FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+field.getDesc()+
                        "' ";
                template.execute(fieldSq);
            }else if(fieldEquals(field)){
                BizClusterTableField oldField = this.getById(field.getId());
                //修改字段名
                if(!field.getFieldName().equals(oldField.getFieldName())){
                    //alter  table OA_QYZ_QYJBXX change Latitude1 Latitude varchar(501) DEFAULT NULL COMMENT '纬度1' ;
                    String fieldSq="ALTER TABLE `"+tableName+"` CHANGE `"+oldField.getFieldName()+"`  `"+ field.getFieldName() +"` "+FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength,
                            decimalLen)+" DEFAULT NULL COMMENT '"+field.getDesc()+"' ";
                    template.execute(fieldSq);
                }
                //
               /* if(field.getFieldName().equals(oldField.getFieldName()) && field.getDesc().equals(oldField.getDesc())){
                    //ALTER TABLE app_user_info MODIFY COLUMN `USER_PHONE_` varchar COMMENT '移动手机号';
                    String fieldSq="ALTER TABLE `"+tableName+"` MODIFY COLUMN `"+oldField.getFieldName()+"` +"+field.getDataType()+" "+field.getDesc()+" ";
                    template.execute(fieldSq);
                }*/
            }
        }
        this.saveOrUpdateBatch(fields);
        //更新建表语句
        String createTableSql=tableManager.queryTableSql(tableId);
        table.setCreateTableSql(createTableSql);
        this.tableManager.updateById(table);
    }

    //判断传过来的字段是不是修改了
    public boolean fieldEquals(BizClusterTableField field){
        BizClusterTableField oldField = this.getById(field.getId());
        if(!field.getFieldName().equals(oldField.getFieldName())|| !field.getDesc().equals(oldField.getDesc()) ){
            return true;
        }
        return false;
    }
}
