package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataCollect.dao.BizClusterDataCountDao;
import com.artfess.dataShare.dataCollect.manager.BizClusterDataCountManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTempDataLogManager;
import com.artfess.dataShare.dataCollect.model.BizClusterDataCount;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTempDataLog;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsTableManager;
import com.artfess.dataShare.dataResource.ods.manager.BizSchedulerCollectTimesManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataResource.ods.model.BizSchedulerCollectTimes;
import com.artfess.dataShare.util.Constants;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 数据汇聚数据统计表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
@Service
public class BizClusterDataCountManagerImpl extends BaseManagerImpl<BizClusterDataCountDao, BizClusterDataCount> implements BizClusterDataCountManager {

    @Resource
    BizSchedulerCollectTimesManager schedulerCollectTimesManager;

    @Resource
    BizClusterTableManager tableManager;

    @Resource
    BizOdsTableManager odsTableManager;

    @Resource
    BizClusterInfoModeManager infoModeManager;

    @Resource
    BizClusterDataCountManager dataCountManager;

    @Resource
    BizClusterTempDataLogManager tempDataLogManager;

    @Resource
    JdbcTemplate jdbcTemplate;

    @Transactional(rollbackFor = Exception.class )
    public void calcClusterInfoDataDay() throws Exception {
        //查询全部汇聚单位,只有库表共享的
        List<BizClusterInfoMode> listInfo = infoModeManager.list();
        for(BizClusterInfoMode item : listInfo ){
            //1.触发器触发临时中间表-所有提供方共用（用于统计数据提供方提供数据量） 当天的数据
            String sql="select t.* from (select company_name_,sys_name_,sys_code_,name_,code_,table_name_,count(src_id_) change_num_,\n" +
                    "sum(case when DATA_TYPE_=1 then 1 else 0 end) add_num_,\n" +
                    "sum(case when DATA_TYPE_=2 then 1 else 0 end) update_num_,\n" +
                    "sum(case when DATA_TYPE_=3 then 1 else 0 end) del_num_,now(),1,date_format(now(),'%Y%m%d')\n" +
                    "from BIZ_CLUSTER_TEMP_DATA where date_format(create_time_,'%Y%m%d')=date_format(now(),'%Y%m%d')\n" +
                    "group by company_name_,sys_name_,sys_code_,name_,code_,table_name_\n" +
                    ") t";
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(item.getDatabaseAlias());

            List<Map<String,Object>> listMap=template.queryForList(sql);
            //数据为0要不要记录
            if(listMap.size()==0){
                BizClusterDataCount dataCount = new BizClusterDataCount();
                dataCount.setCompanyName(item.getCompanyName());
                dataCount.setSysName(item.getSysName());
                dataCount.setSysCode(item.getSysCode());
                //dataCount.setTableName();
                //dataCount.setName(map.get("name_").toString());
                //dataCount.setCode(map.get("code_").toString());
                dataCount.setChangeNum(0L);
                dataCount.setAddNum(0L);
                dataCount.setUpdateNum(0L);
                dataCount.setDelNum(0L);
                dataCount.setCreateDate(LocalDate.now());
                dataCount.setCountDate(LocalDate.now());
                dataCountManager.save(dataCount);
            }
            List<BizClusterDataCount> list= new ArrayList<>();
            for(Map<String,Object> map : listMap){
                BizClusterDataCount dataCount = new BizClusterDataCount();
                dataCount.setCompanyName(map.get("company_name_").toString());
                dataCount.setSysName(map.get("sys_name_").toString());
                dataCount.setSysCode(map.get("sys_code_").toString());
                dataCount.setTableName(map.get("table_name_").toString());
                dataCount.setName(map.get("name_").toString());
                dataCount.setCode(map.get("code_").toString());
                dataCount.setChangeNum(Long.parseLong(map.get("change_num_").toString()));
                dataCount.setAddNum(Long.parseLong(map.get("add_num_").toString()));
                dataCount.setUpdateNum(Long.parseLong(map.get("update_num_").toString()));
                dataCount.setDelNum(Long.parseLong(map.get("del_num_").toString()));
                dataCount.setCreateDate(LocalDate.now());
                dataCount.setCountDate(LocalDate.now());
                list.add(dataCount);
            }
            if(list.size()>0) {
                dataCountManager.saveBatch(list);
            }
            //复制触发器触发临时中间表-所有提供方共用到提供方每次推送明细记录表
            //String copySql="insert into BIZ_CLUSTER_TEMP_DATA_LOG select * from BIZ_CLUSTER_TEMP_DATA where date_format(create_time_,'%Y%m%d')=date_format(now(),'%Y%m%d')";
            //template.execute(copySql);
            List<Map<String,Object>> listTemp=template.queryForList("select * from BIZ_CLUSTER_TEMP_DATA where date_format(create_time_,'%Y%m%d')=date_format(now(),'%Y%m%d')");
            List<BizClusterTempDataLog> listLog= new ArrayList<>();
            List<String> tempIds=new ArrayList<>();
            for(Map<String,Object> map : listTemp){
                tempIds.add(map.get("id_").toString());
                BizClusterTempDataLog dataCountLog = new BizClusterTempDataLog();
                dataCountLog.setCompanyName(map.get("company_name_").toString());
                dataCountLog.setSysName(map.get("sys_name_").toString());
                dataCountLog.setSysCode(map.get("sys_code_").toString());
                dataCountLog.setName(map.get("name_").toString());
                dataCountLog.setCode(map.get("code_").toString());
                dataCountLog.setTableName(map.get("table_name_").toString());
                dataCountLog.setDataType(Integer.parseInt(map.get("data_type_").toString()));
                dataCountLog.setSrcId(map.get("SRC_ID_").toString());
                dataCountLog.setCreateTime(LocalDateTime.now());
                listLog.add(dataCountLog);
            }
            if(listLog.size()>0) {
                tempDataLogManager.saveBatch(listLog);
            }
            //查询所有汇聚方下的表，计算表中数据数量
            String updateSql="update BIZ_CLUSTER_DATA_COUNT set TOTAL_NUM_=? where  COUNT_DATE_=date_format(now(),'%Y%m%d') and table_name_= ?";
            String updateTableTotalSql="update BIZ_CLUSTER_TABLE set TOTAL_NUM_=? where TABLE_NAME_EN_= ?";
            List<Object[]> paramList=new ArrayList<>();
            List<BizClusterTable> tableList = tableManager.queryTableByClusterId(item.getId());
            for(BizClusterTable table : tableList){
                if(!"1".equals(table.getDeployed())){
                    continue;
                }
                String queryTableCount="select count(*) from "+table.getTableNameEn();
                Integer count = template.queryForObject(queryTableCount,Integer.class);
                Object[] obj= {count,table.getTableNameEn()};
                paramList.add(obj);
            }
            if(paramList.size()>0) {
                jdbcTemplate.batchUpdate(updateSql, paramList);
                jdbcTemplate.batchUpdate(updateTableTotalSql, paramList);
            }
            if(tempIds.size()>0) {
                //删除临时数据
                template.execute("delete from BIZ_CLUSTER_TEMP_DATA where id_ in ('" + tempIds.stream().collect(Collectors.joining("','")) + "')");
            }
        }

    }

    //计算触发器的数据到ODS表，同步完成后删除临时表数据  由陈实实现
    @Transactional(rollbackFor = Exception.class )
    public void calcClusterGatherOds() throws Exception {
        //ods数据源
        JdbcTemplate odsTemplate = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
        //查询全部汇聚单位,只有库表共享的
        List<BizClusterInfoMode> listInfo = infoModeManager.list();
        List<BizSchedulerCollectTimes> collectTimesList= new ArrayList<>();
        for(BizClusterInfoMode item : listInfo ){
            //获取共享库数据源
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(item.getDatabaseAlias());
            List<Map<String,Object>> listTemp=template.queryForList("select table_name_,data_type_,GROUP_CONCAT(src_id_) ids from BIZ_CLUSTER_COLLECT_DATA group by table_name_,data_type_ order by table_name_");
            List<String> delTableName=new ArrayList<>();
            //验证表在ods里面存在才计算，否则就删除数据
            for(Map<String,Object> map : listTemp){
                String tableName=map.get("table_name_").toString();
                String queryTableDataSql="SELECT count(1) FROM information_schema.tables WHERE table_schema = '"+item.getDatabaseName()+"' AND table_name = '"+tableName+"'";
                Integer isExtistsTable=template.queryForObject(queryTableDataSql,Integer.class);
                if(isExtistsTable==0){
                    delTableName.add(tableName);
                }
            }
            if(delTableName.size()>0){
                listTemp=listTemp.stream().filter(p->!delTableName.contains(p.get("table_name_"))).collect(Collectors.toList());
            }
            QueryWrapper<BizOdsTable> queryWrapper = new QueryWrapper<>();
            //queryWrapper.eq("TABLE_NAME_EN_", "ods_"+p.get("table_name_"));
            queryWrapper.last(" limit 1");
            BizOdsTable table = this.odsTableManager.getOne(queryWrapper);
            if(null==table){
                continue;
            }
            //记录采集的Id,操作完成后删除id对应的日志数据
            List<String> tempIds=new ArrayList<>();
            int insertNum=0;
            int updateNum=0;
            int delNum=0;
            for(Map<String,Object> map : listTemp){
                String ids = map.get("ids").toString();
                if(ids.indexOf(",")>0){
                    tempIds.addAll(Arrays.asList(ids.split(",")));
                }
                String tableName=map.get("table_name_").toString();
                String dataType=map.get("data_type_").toString();

                //1：新增，2：修改，3：删除
                if("1".equalsIgnoreCase(dataType)){
                    String queryTableDataSql="select * from "+tableName+" where id_ in ('"+ids.replace(",","','")+"')";
                    List<Map<String,Object>> queryTableData=template.queryForList(queryTableDataSql);
                    List<Object[]> param=new ArrayList<>();
                    String insertSql="insert into ods_"+tableName;
                    for(int i=0;i<queryTableData.size();i++) {
                        Map<String,Object> tableData = queryTableData.get(i);
                        tableData.remove("REF_ID_");
                        tableData.remove("F_form_data_rev_");
                        tableData.remove("form_data_rev_");
                        if(i==0){
                            String field="";
                            String val="";
                            for(String key : tableData.keySet()){
                               /* if("REF_ID_".equalsIgnoreCase(key) || "F_form_data_rev_".equalsIgnoreCase(key)|| "form_data_rev_".equalsIgnoreCase(key)){
                                    continue;
                                }*/
                                key=key.replaceFirst("F_","");
                                field+=key+",";
                                val+="?,";
                            }
                            insertSql += "("+field.substring(0,field.length()-1)+") values("+val.substring(0,val.length()-1)+")";

                            param.add(tableData.values().toArray());
                        }else{
                            param.add(tableData.values().toArray());
                        }
                    }
                    if(param.size()>0) {
                        odsTemplate.batchUpdate(insertSql, param);
                        insertNum=param.size();
                    }
                }else if("2".equalsIgnoreCase(dataType)){
                    String queryTableDataSql="select * from "+tableName+" where id_ in ('"+ids.replace(",","','")+"')";
                    List<Map<String,Object>> queryTableData=template.queryForList(queryTableDataSql);
                    List<String> sql=new ArrayList<>();
                    for(int i=0;i<queryTableData.size();i++) {
                        Map<String, Object> tableData = queryTableData.get(i);
                        String id=tableData.get("id_").toString();
                        String updateSql="update ods_"+tableName +" set ";
                        for(String key : tableData.keySet()){
                            if ("REF_ID_".equalsIgnoreCase(key) || "F_form_data_rev_".equalsIgnoreCase(key)|| "form_data_rev_".equalsIgnoreCase(key)) {
                                continue;
                            }
                            if(!"id_".equalsIgnoreCase(key)){
                                String newKey=key.replaceFirst("F_","");
                                if(null==tableData.get(key)){
                                    continue;
                                }
                                updateSql+= newKey+"= '"+tableData.get(key)+"',";
                            }
                        }
                        if(updateSql.indexOf(",")>1){
                            updateSql=updateSql.substring(0,updateSql.length()-1);
                        }
                        updateSql+=" where id_= '"+id+"'";
                        sql.add(updateSql);
                    }
                    if(sql.size()>0) {
                        String[] updateSql = new String[sql.size()];
                        odsTemplate.batchUpdate(sql.toArray(updateSql));
                        insertNum=sql.size();
                    }
                }else if("3".equalsIgnoreCase(dataType)){
                    if(StringUtil.isNotEmpty(ids)) {
                        //修改数据状态未删除
                        odsTemplate.execute("update ods_" + tableName + " set IS_DELE_=1 where id_ in ('" + ids.replace(",", "','") + "')");
                        delNum=tempIds.size();
                    }
                }

            }


            //schedulerCollectTimesManager
            /*BizSchedulerCollectTimes collectTimes=new BizSchedulerCollectTimes();
            collectTimes.setCompanyName(item.getCompanyName());
            collectTimes.setSysName(item.getSysName());
            collectTimes.setSysCode(item.getSysCode());
            collectTimes.setTableName("ods_"+tableName);
            collectTimes.setName(table.getName());
            collectTimes.setCode(table.getCode());
            collectTimes.setTotalNum(insertNum+updateNum+delNum);
            collectTimes.setAddNum(insertNum);
            collectTimes.setUpdateNum(updateNum);
            collectTimes.setDelNum(delNum);
            collectTimes.setCreateTime(LocalDateTime.now());
            collectTimes.setCountDate(LocalDateTime.now());
            collectTimes.setStatus("1");
            collectTimesList.add(collectTimes);*/

            if(collectTimesList.size()>0) {
                schedulerCollectTimesManager.saveBatch(collectTimesList);
            }
            if(tempIds.size()>0) {
                //删除临时数据
                template.execute("delete from biz_cluster_collect_data where id_ in ('" + tempIds.stream().collect(Collectors.joining("','")) + "')");
            }
        }

        //查询所有ODS的表，计算表中数据数量
        String updateTableTotalSql="update BIZ_ODS_CATALOGS_TABLE set TOTAL_NUM_=? where TABLE_NAME_EN_= ?";
        List<Object[]> paramList=new ArrayList<>();
        List<BizOdsTable> tableList = odsTableManager.queryDeployed();
        for(BizOdsTable table : tableList){
            String queryTableCount="select count(*) from "+table.getTableNameEn();
            Integer count = odsTemplate.queryForObject(queryTableCount,Integer.class);
            Object[] obj= {count,table.getTableNameEn()};
            paramList.add(obj);
        }
        if(paramList.size()>0) {
            jdbcTemplate.batchUpdate(updateTableTotalSql, paramList);
        }
    }
}
