package com.artfess.dataShare.dataCollect.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataCollect.vo.BizDataSourceVo;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataCollect.model.BizDatasourcesRelation;
import com.artfess.dataShare.dataCollect.manager.BizDatasourcesRelationManager;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据源关联表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
@RestController
@RequestMapping("/biz/datasourcesRelation/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
@Api(tags = "数据源关联表")
public class BizDatasourcesRelationController extends BaseController<BizDatasourcesRelationManager, BizDatasourcesRelation> {
    @Resource
    SysDataSourceManager sysDataSourceManager;

    /**
     * 保存sys_data_source信息
     *
     * @throws Exception void
     */
    @RequestMapping(value = "save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存数据源信息", httpMethod = "POST", notes = "保存数据源信息")
    public CommonResult<String> save(@ApiParam(name = "sysDataSource", value = "数据源对象", required = true) @RequestBody BizDataSourceVo bizDataSourceVo) throws Exception {

        SysDataSource sysDataSource = new SysDataSource();
        BeanUtils.copyNotNullProperties(sysDataSource, bizDataSourceVo);
        boolean isConnection = sysDataSourceManager.checkConnection(sysDataSource);

        boolean isAliasExist = sysDataSourceManager.isAliasExist(sysDataSource.getAlias());

        if (isAliasExist && StringUtil.isEmpty(sysDataSource.getId())) {
            return new CommonResult<String>(false, "别名已存在");
        }

        if (!isConnection) {
            return new CommonResult<String>(false, "连接数据库失败，操作失败");
        }
        String dataSourceId = sysDataSource.getId();
        String resultMsg = null;
        String sourceId=UniqueIdUtil.getSuid();
        if (StringUtil.isEmpty(dataSourceId)) {
            sysDataSource.setId(sourceId);
            sysDataSourceManager.create(sysDataSource);
            resultMsg = "添加成功,并连接测试通过";
        } else {
            sysDataSourceManager.update(sysDataSource);
            resultMsg = "更新成功,并连接测试通过";
        }
        if (StringUtil.isEmpty(dataSourceId)) {
            BizDatasourcesRelation relation = new BizDatasourcesRelation();
            relation.setAlias(sysDataSource.getAlias());
            relation.setDatasourcesType(bizDataSourceVo.getDatasourcesType());
            relation.setId(sourceId);
            this.create(relation);
        } else {
            BizDatasourcesRelation relation = new BizDatasourcesRelation();
            BeanUtils.copyNotNullProperties(relation, bizDataSourceVo);
            this.updateById(relation);
        }
        return new CommonResult<String>(resultMsg);
    }

    @GetMapping("/detail/{id}")
    @ApiOperation("根据id查询实体和数据源")
    public BizDataSourceVo getDataSourceById(@ApiParam(name = "id", value = "实体id") @PathVariable String id)  throws Exception{
        BizDataSourceVo vo = new BizDataSourceVo();
        BizDatasourcesRelation relation=baseService.getById(id);
        if(relation==null){
            throw new ApplicationException("未查询到数据源");
        }
        SysDataSource sysDataSource = sysDataSourceManager.getByAlias(relation.getAlias());
        if(sysDataSource==null){
            throw new ApplicationException("未查询到关联数据源");
        }
        BeanUtils.copyNotNullProperties(vo, relation);
        BeanUtils.copyNotNullProperties(vo, sysDataSource);
        return vo;
    }

    @PostMapping("/queryList/{type}")
    @ApiOperation("查询数据源列表")
    public List<BizDataSourceVo> queryList(@ApiParam(name = "type", value = "数据源类型（1：汇聚交换，2：ODS，3：DW，4：共享）") @PathVariable Integer type)  throws Exception{
        if(null==type){
            type=1;
        }
        return baseService.queryList(type);
    }

    /*@GetMapping("/queryDataSourceByType")
    @ApiOperation("根据类型查询数据源列表")
    public List<BizDatasourcesRelation> queryDataSourceByType(@ApiParam(name = "type", value = "数据源类型（1：汇聚交换，2：ODS，3：DW，4：共享）") @RequestParam Integer type)  throws Exception{
        List<BizDatasourcesRelation> list = this.baseService.queryBizDataSourceByType(type);
        return list;
    }*/
}