package com.artfess.dataShare.dataCollect.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableFieldManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据汇聚字段信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-10
 */
@RestController
@RequestMapping("/biz/dataCollect/clusterField/v1/")
@Api(tags = "数据汇聚-数据汇聚表字段信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizClusterTableFieldController extends BaseController<BizClusterTableFieldManager, BizClusterTableField> {

    @Resource
    BizClusterTableFieldManager fieldManager;

    @PostMapping("/importFile")
    @ApiOperation(value = "导入数据汇聚字段信息", httpMethod = "POST", notes = "导入数据汇聚字段信息")
    public CommonResult<String> export(@RequestParam(value = "file", required = true) MultipartFile file,@RequestParam String tableId) throws Exception {
        this.fieldManager.export(file,tableId);
        return new CommonResult<String>(true, "导入数据汇聚表字段成功");
    }

    @PostMapping("/saveTableField")
    @ApiOperation(value = "批量维护数据汇表和聚字段信息", httpMethod = "POST", notes = "批量维护数据汇表和聚字段信息")
    public CommonResult<String> saveTableField(@RequestBody TableDetailVo vo) throws Exception {
        this.fieldManager.saveTableField(vo);
        return new CommonResult<String>(true, "批量维护数据汇聚字段信息");
    }

    @PostMapping("/saveOrUpdates")
    @ApiOperation(value = "批量维护数据汇聚字段信息-单独保存字段，全度需要在每个字段里面加上tableId", httpMethod = "POST", notes = "导入数据汇聚字段信息")
    public CommonResult<String> saveTableField(@RequestBody List<BizClusterTableField> field) throws Exception {
        this.fieldManager.saveOrUpdateBatch(field);
        return new CommonResult<String>(true, "批量维护数据汇聚字段信息");
    }

    @PostMapping("/saveOrUpdateFields")
    @ApiOperation(value = "修改发布后的表字段信息-同时要修改实体表", httpMethod = "POST", notes = "修改发布后的表字段信息-同时要修改实体表")
    public CommonResult<String> saveOrUpdateFields(@RequestBody List<BizClusterTableField> field) throws Exception {
        this.fieldManager.saveOrUpdateFields(field);
        return new CommonResult<String>(true, "修改成功");
    }
}
