package com.artfess.dataShare.algorithm.manager.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmReasonDao;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmCatalogsIndexManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmReasonManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmRelationManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmCatalogsIndex;
import com.artfess.dataShare.algorithm.model.BizAlgorithmReason;
import com.artfess.dataShare.algorithm.vo.TaskReasonVo;
import com.artfess.dataShare.util.ExcelFillCellMergeStrategy;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 算法推理管理----逻辑推理编排表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@Service
public class BizAlgorithmReasonManagerImpl extends BaseManagerImpl<BizAlgorithmReasonDao, BizAlgorithmReason> implements BizAlgorithmReasonManager {

    @Resource
    BizAlgorithmCatalogsIndexManager indexManager;

    @Resource
    BizAlgorithmReasonDao reasonDao;

    public void saveReason(BizAlgorithmReason reason){
        String id=reason.getId();
        BizAlgorithmReason temp=this.getById(id);
        if(null==temp) {
            this.saveTree(reason,false);
        }else{
            this.updateTree(reason,temp.getName(),false);
        }
        /*String parentId=reason.getParentId();
        if(StringUtils.isNotBlank(parentId)){
            BizAlgorithmReason parent=this.getById(parentId);
            if(null!=parent){
                reason.setFullIndexCode(parent.getFullIndexCode()+"/"+reason.getIndexCode());
                reason.setFullIndexName(parent.getFullIndexName()+"/"+reason.getIndexName());
                reason.setFullIndexId(parent.getFullIndexId()+"/"+reason.getId());
            }
        }
        if(StringUtils.isNotBlank(reason.getId())){
            this.update(reason);
        }else{
            this.create(reason);
        }*/
    }

    @Override
    public List<BizAlgorithmReason> queryByVersionId(String versionId) {
        QueryWrapper<BizAlgorithmReason> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TASK_VERSON_ID",versionId);
        queryWrapper.orderByAsc("FULL_ID_");
        List<BizAlgorithmReason> list = this.list(queryWrapper);
        /*for(BizAlgorithmReason reason : list){
            List<BizAlgorithmRelation> relationList = relationManager.queryByCurrentIndexId(reason.getId());
            reason.setRelationList(relationList);
        }*/
        return list;
    }

    @Override
    public List<BizAlgorithmReason> queryByTypeAndVersionId(String versionId,Integer type){
        QueryWrapper<BizAlgorithmReason> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TASK_VERSON_ID",versionId);
        queryWrapper.eq("TYPE_",type);
        queryWrapper.orderByAsc("FULL_ID_");
        List<BizAlgorithmReason> list = this.list(queryWrapper);
        /*for(BizAlgorithmReason reason : list){
            List<BizAlgorithmRelation> relationList = relationManager.queryByCurrentIndexId(reason.getId());
            reason.setRelationList(relationList);
        }*/
        return list;
    }

    @Override
    public List<BizAlgorithmReason> queryTreeByVersionId(String versionId) {
        BizAlgorithmReason reason=new BizAlgorithmReason();
        reason.setTaskVersonId(versionId);
        return this.getTree(reason);
    }

    @Override
    public List<BizAlgorithmReason> getTree(BizAlgorithmReason entity) {
        QueryWrapper<BizAlgorithmReason> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }
        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("TASK_VERSON_ID", entity.getTaskVersonId());
        }
        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }
        queryWrapper.orderByAsc("sn_");
        List<BizAlgorithmReason> sysList = this.baseMapper.selectList(queryWrapper);
        List<BizAlgorithmReason> tree = BeanUtils.listToTree(sysList);
        return tree;
    }

    @Override
    public List<TaskReasonVo> queryTaskAndReason(String indexId,String type){
        //需要确认是不是只把已经发布的版本对应的指标查询出来，还是全部已经关联的
        /*select t.id_,t.task_id_,t1.NAME_,t1.CODE_ reason_code,t.NAME_ reason_name,t.CODE_,t1.ROUTINE_NAME_,t1.ROUTINE_CODE_,t.TYPE_,t.content_,t.RELATION_CONTENT_ from biz_algorithm_reason t
        left join biz_algorithm_taskinfo t1 on t.task_id_ = t1.id_*/
        List<TaskReasonVo> voList=reasonDao.queryTaskReasonList(indexId,type);
        return voList;
    }

    public String exportTaskAndReason(String indexId,String type){
        //需要确认是不是只把已经发布的版本对应的指标查询出来，还是全部已经关联的
        /*select t.id_,t.task_id_,t1.NAME_,t1.CODE_ reason_code,t.NAME_ reason_name,t.CODE_,t1.ROUTINE_NAME_,t1.ROUTINE_CODE_,t.TYPE_,t.content_,t.RELATION_CONTENT_ from biz_algorithm_reason t
        left join biz_algorithm_taskinfo t1 on t.task_id_ = t1.id_*/
        BizAlgorithmCatalogsIndex catalogsIndex=indexManager.getById(indexId);
        List<TaskReasonVo> voList=reasonDao.queryTaskReasonList(indexId,type);
        List<List<String>> dataOneToMoreList=new ArrayList<>();
        List<List<String>> dataList=new ArrayList<>();
        List<List<String>> headOneToMore = new ArrayList<>();
        List<List<String>> headMoreToOne = new ArrayList<>();
        if("1".equals(type)){
            //一推多
            //结果指标【孔雀型】（一推多）
            //指标类型	指标名称	推理类型	算法推理任务名称	任务版本	关联指标（下级）	指标类型	关联描述	计算工式说明
            String headOneStr="指标类型,指标名称,推理类型,算法推理任务名称,任务版本,关联指标（下级）,指标类型,关联描述,计算工式说明";
            String head1=getLevelStr(catalogsIndex.getLevel())+"【"+catalogsIndex.getName()+"】（一推多）";
            List<String> oneHead = Arrays.asList(headOneStr.split(","));
            for(String head : oneHead){
                List<String> oneHeads = new ArrayList<>();
                oneHeads.add(head1);
                oneHeads.add(head);
                headOneToMore.add(oneHeads);
            }
            List<TaskReasonVo> typeOneToMore = voList.stream().filter(p->"1".equals(p.getType())).collect(Collectors.toList());
            for(TaskReasonVo vo : typeOneToMore){
                List<String> data = new ArrayList<>();
                data.add(getLevelStr(vo.getLevel()));
                data.add(vo.getName());
                data.add(vo.getContent());
                data.add(vo.getRelationContent());
                data.add(vo.getVersionName());
                data.add(vo.getTaskName());
                data.add("一推多");
                data.add(vo.getReasonName());
                data.add(getLevelStr(vo.getIndexType()));
                dataOneToMoreList.add(data);
            }
        }else if("2".equals(type)){
            //多推一
            //结果指标【孔雀型】（多推一）
            //指标类型	指标名称	关联描述	计算说明	任务版本	算法推理任务名称	推理类型	指标名称	指标类型
            String headMoreStr="指标类型,指标名称,关联描述,计算说明,任务版本,算法推理任务名称,推理类型,指标名称,指标类型";
            String head2=getLevelStr(catalogsIndex.getLevel())+"【"+catalogsIndex.getName()+"】（多推一）";
            List<String> oneHead1 = Arrays.asList(headMoreStr.split(","));
            for(String head : oneHead1){
                List<String> oneHeads = new ArrayList<>();
                oneHeads.add(head2);
                oneHeads.add(head);
                headMoreToOne.add(oneHeads);
            }

            List<TaskReasonVo> typeMoreToOne = voList.stream().filter(p->"2".equals(p.getType())).collect(Collectors.toList());
            for(TaskReasonVo vo : typeMoreToOne){
                List<String> data = new ArrayList<>();
                data.add(getLevelStr(vo.getIndexType()));
                data.add(vo.getReasonName());
                data.add(vo.getContent());
                data.add(vo.getRelationContent());
                data.add(vo.getVersionName());
                data.add(vo.getTaskName());
                data.add("多推一");
                data.add(vo.getName());
                data.add(getLevelStr(vo.getLevel()));

                dataList.add(data);
            }
        }



        String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
        FileUtil.createFolder(rootRealPath, true);
        String filePath = rootRealPath+File.separator+System.currentTimeMillis()+".xls";
        try {
            FileOutputStream outputStream = new FileOutputStream(new File(filePath));
            ExcelWriter writer = EasyExcel.write(outputStream).build();
            if("1".equals(type)) {
                WriteSheet sheet = EasyExcel.writerSheet(0).needHead(Boolean.FALSE).sheetName("一推多").build();
                WriteTable table = EasyExcel.writerTable(1).head(headOneToMore)
                        // 设置只合并第1、2、3列，其余不合并
                        .registerWriteHandler(new ExcelFillCellMergeStrategy(1, new int[]{0, 1, 2, 3, 4}))
                        .needHead(Boolean.TRUE).build();
                writer.write(dataOneToMoreList, sheet, table); // data
            }else if("2".equals(type)){
                WriteSheet sheet1 = EasyExcel.writerSheet(1).needHead(Boolean.FALSE).sheetName("多推一").build();
                WriteTable table1 = EasyExcel.writerTable(2).head(headMoreToOne)
                        // 设置只合并第1、2、3列，其余不合并
                        .registerWriteHandler(new ExcelFillCellMergeStrategy(1, new int[]{4, 5, 6, 7, 8}))
                        .needHead(Boolean.TRUE).build();
                writer.write(dataList, sheet1, table1); // data
            }
            writer.finish();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }

    @Override
    public List<BizAlgorithmReason> queryReason(String taskId, String versionId) {
        return this.reasonDao.queryReason(taskId,versionId);
    }

    //指标分类（1：结果指标 2：问题指标 3：属性指标）
    public String getLevelStr(String level){
        if("1".equals(level)){
            return "结果指标";
        }else if("12".equals(level)){
            return "问题指标";
        }else if("3".equals(level)){
            return "属性指标";
        }
        return "";
    }
}