package com.artfess.dataShare.algorithm.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmVersion;
import com.artfess.dataShare.algorithm.vo.TaskVersionVo;

/**
 * 算法推理管理----算法推理任务版本管理表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
public interface BizAlgorithmVersionManager extends BaseManager<BizAlgorithmVersion> {

    /**
     * 保存算法推理信息表
     */
    void saveTaskVersion(TaskVersionVo vo) throws Exception;

    /**
     * 查询任务版本信息
     * @param versionId 版本的ID
     * @return
     * @throws Exception
     */
    TaskVersionVo queryVersion(String versionId) throws Exception;

    /**
     * 获取一个最新的版本号
     * @param id
     * @throws Exception
     */
    String getNewVersionCode(String id) throws Exception;

    /**
     * 复制版本
     * @param versionId 版本ＩＤ
     */
    String saveAsTaskVersion(String versionId) throws Exception;
}
