package com.artfess.dataShare.algorithm.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmResultItemManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmResultItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 算法推理管理----指标值结果关联配置表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@RestController
@RequestMapping("/biz/algorithm/resultItem/v1/")
@Api(tags = "算法推理管理----指标值结果关联配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizAlgorithmResultItemController extends BaseController<BizAlgorithmResultItemManager, BizAlgorithmResultItem> {

    @PostMapping("/saveAlgorithmResultItemBatch")
    @ApiOperation("批量保存指标值结果关联配置")
    public CommonResult<String> saveAlgorithmResultItemBatch(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) List<BizAlgorithmResultItem> list) {
        baseService.saveOrUpdateBatch(list);
        return new CommonResult<String>(true, "保存成功");
    }
}
