/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi;

import com.artfess.poi.DefaultExcelStyle;
import com.artfess.poi.ExcelContext;
import com.artfess.poi.editor.CellEditor;
import com.artfess.poi.editor.ColumnEditor;
import com.artfess.poi.editor.IFontEditor;
import com.artfess.poi.editor.RegionEditor;
import com.artfess.poi.editor.RowEditor;
import com.artfess.poi.editor.SheetEditor;
import com.artfess.poi.style.Align;
import com.artfess.poi.style.BorderStyle;
import com.artfess.poi.style.Color;
import com.artfess.poi.style.font.BoldWeight;
import com.artfess.poi.style.font.Font;
import com.artfess.poi.util.ExcelUtil;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.core.io.ClassPathResource;

public class Excel {
    private ExcelContext ctx;

    public Excel() {
        this(new DefaultExcelStyle());
    }

    public Excel(DefaultExcelStyle defaultStyle) {
        this(null, defaultStyle);
    }

    public Excel(String excelPath) {
        this(excelPath, new DefaultExcelStyle());
    }

    public Excel(String excelPath, DefaultExcelStyle defaultStyle) {
        HSSFWorkbook workBook;
        if (excelPath == null || excelPath.trim().equals("")) {
            workBook = new HSSFWorkbook();
        } else {
            workBook = this.readExcel(excelPath);
            if (workBook == null) {
                workBook = new HSSFWorkbook();
            }
        }
        this.ctx = new ExcelContext(this, workBook);
        this.ctx.setDefaultStyle(defaultStyle);
        this.setWorkingSheet(0);
        HSSFCellStyle tempCellStyle = workBook.createCellStyle();
        this.ctx.setTempCellStyle(tempCellStyle);
        HSSFFont tempFont = workBook.createFont();
        this.ctx.setTempFont(tempFont);
        HSSFCell cell = ExcelUtil.getHSSFCell(this.ctx.getWorkingSheet(), 0, 0);
        HSSFCellStyle cellStyle = cell.getCellStyle();
        cellStyle.setFillForegroundColor(defaultStyle.getBackgroundColor().getIndex());
        cellStyle.setFillPattern(defaultStyle.getFillPattern());
        cellStyle.setAlignment(defaultStyle.getAlign());
        cellStyle.setVerticalAlignment(defaultStyle.getVAlign());
        cellStyle.setBorderBottom(defaultStyle.getBorderStyle());
        cellStyle.setBorderLeft(defaultStyle.getBorderStyle());
        cellStyle.setBorderRight(defaultStyle.getBorderStyle());
        cellStyle.setBorderTop(defaultStyle.getBorderStyle());
        cellStyle.setBottomBorderColor(defaultStyle.getBorderColor().getIndex());
        cellStyle.setTopBorderColor(defaultStyle.getBorderColor().getIndex());
        cellStyle.setLeftBorderColor(defaultStyle.getBorderColor().getIndex());
        cellStyle.setRightBorderColor(defaultStyle.getBorderColor().getIndex());
        HSSFFont font = cellStyle.getFont((Workbook)workBook);
        font.setFontHeightInPoints(defaultStyle.getFontSize());
        font.setFontName(defaultStyle.getFontName());
        font.setColor(defaultStyle.getFontColor().getIndex());
    }

    private HSSFWorkbook readExcel(String excelPath) {
        HSSFWorkbook result = null;
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelPath));
            result = new HSSFWorkbook(fs);
        }
        catch (Exception ex) {
            try {
                POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getResourceAsStream(excelPath));
                result = new HSSFWorkbook(fs);
            }
            catch (Exception e1) {
                try {
                    ClassPathResource classPathResource = new ClassPathResource(excelPath);
                    InputStream stream = classPathResource.getInputStream();
                    POIFSFileSystem fs = new POIFSFileSystem(stream);
                    result = new HSSFWorkbook(fs);
                }
                catch (Exception e) {
                    try {
                        InputStream stream = null;
                        StackTraceElement[] st = new Throwable().getStackTrace();
                        for (int i = 2; i < st.length; ++i) {
                            stream = Class.forName(st[i].getClassName()).getResourceAsStream(excelPath);
                            if (stream == null) continue;
                            POIFSFileSystem fs = new POIFSFileSystem(stream);
                            result = new HSSFWorkbook(fs);
                            break;
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public boolean saveExcel(String excelPath) {
        try {
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(excelPath));
            return this.saveExcel(fileOut);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveExcel(OutputStream fileOut) {
        boolean result = false;
        try {
            this.ctx.getWorkBook().write(fileOut);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileOut.flush();
                fileOut.close();
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public SheetEditor setWorkingSheet(int index) {
        if (index < 0) {
            index = 0;
        }
        this.ctx.setWorkingSheet(ExcelUtil.getHSSFSheet(this.ctx.getWorkBook(), index));
        return this.sheet(index);
    }

    public CellEditor cell(int row, int col) {
        CellEditor cellEditor = new CellEditor(row, col, this.ctx);
        return cellEditor;
    }

    public RowEditor row(int row) {
        return new RowEditor(row, this.ctx);
    }

    public RowEditor row(int row, int startCol) {
        return new RowEditor(row, startCol, this.ctx);
    }

    public RowEditor row() {
        int rowNum = ExcelUtil.getLastRowNum(this.ctx.getWorkingSheet());
        if (!this.checkEmptyRow(rowNum)) {
            ++rowNum;
        }
        return new RowEditor(rowNum, this.ctx);
    }

    private boolean checkEmptyRow(int rowNum) {
        HSSFRow row = this.ctx.getWorkingSheet().getRow(rowNum);
        int lastCell = row != null ? (int)row.getLastCellNum() : 2;
        return lastCell == 1 || lastCell == -1;
    }

    public ColumnEditor column(int col) {
        ColumnEditor columnEditor = new ColumnEditor(col, this.ctx);
        return columnEditor;
    }

    public ColumnEditor column(int col, int startRow) {
        ColumnEditor columnEditor = new ColumnEditor(col, startRow, this.ctx);
        return columnEditor;
    }

    public RegionEditor region(int beginRow, int beginCol, int endRow, int endCol) {
        RegionEditor regionEditor = new RegionEditor(beginRow, beginCol, endRow, endCol, this.ctx);
        return regionEditor;
    }

    public RegionEditor region(String ref) {
        RegionEditor regionEditor = new RegionEditor(CellRangeAddress.valueOf((String)ref), this.ctx);
        return regionEditor;
    }

    public SheetEditor sheet(int index) {
        if (index < 0) {
            index = 0;
        }
        SheetEditor sheetEditor = new SheetEditor(ExcelUtil.getHSSFSheet(this.ctx.getWorkBook(), index), this.ctx);
        return sheetEditor;
    }

    public SheetEditor sheet() {
        return this.sheet(this.ctx.getWorkingSheetIndex());
    }

    public HSSFWorkbook getWorkBook() {
        return this.ctx.getWorkBook();
    }

    public int getWorkingSheetIndex() {
        return this.ctx.getWorkingSheetIndex();
    }

    public Name createName(String name, String formulaText) {
        HSSFName refersName = this.ctx.getWorkBook().createName();
        refersName.setNameName(name);
        refersName.setRefersToFormula(formulaText);
        return refersName;
    }

    public static void main(String[] args) {
        Object[] val = new Object[]{"\u63d2\u5165\u4e00\u884c\u6570\u636e", 123, Character.valueOf('A'), Math.PI, new Date(), "hello"};
        Excel excel = new Excel();
        excel.cell(0, 0).value("Hello World!").align(Align.CENTER).bgColor(Color.LIGHT_YELLOW).height(30.0f).font(new IFontEditor(){

            @Override
            public void updateFont(Font font) {
                font.boldweight(BoldWeight.BOLD);
                font.color(Color.BROWN);
            }
        });
        excel.region(0, 0, 0, 10).merge();
        excel.region("$A$2:$K$2").merge();
        ((RowEditor)excel.row(2).value(val).addWidth(2000)).borderOuter(BorderStyle.DASH_DOT_DOT, Color.CORAL);
        excel.row(4, 1).value(val).borderFull(BorderStyle.DASH_DOT, Color.RED);
        excel.row(6).value(val, 2).borderTop(BorderStyle.THIN, Color.BLUE);
        ((ColumnEditor)((ColumnEditor)excel.column(11).value(val).align(Align.CENTER)).borderFull(BorderStyle.THICK, Color.CORNFLOWER_BLUE)).autoWidth();
        excel.cell(7, 0).value("=IF(B3=123,\"\u7b49\u4e8e\",\"\u4e0d\u7b49\u4e8e\")");
        excel.cell(7, 1).value(0.578923).dataFormat("0.00%");
        excel.cell(7, 2).value(0.578923, "0.00%");
        excel.sheet().freeze(1, 0).sheetName("\u8fd9\u662f\u7b2c\u4e00\u4e2a\u8868");
        excel.cell(8, 5).value("\u8fd9\u4e2a\u5355\u5143\u683c\u8bbe\u7f6e\u4e86\u5907\u6ce8").comment("\u8fd9\u662f\u4e00\u6761\u5907\u6ce8");
        excel.setWorkingSheet(1).sheetName("\u7b2c\u4e8c\u4e2a\u8868");
        excel.row(0).value(val);
        excel.sheet().groupColumn(0, 3);
        excel.saveExcel("D:/helloworld.xls");
    }
}

