/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.handler;

import com.artfess.base.context.BaseContext;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AutoFillMetaObjectHandler
implements MetaObjectHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    BaseContext baseContext;

    public void insertFill(MetaObject metaObject) {
        this.logger.info("start insert fill ....");
        this.strictInsertFill(metaObject, "createBy", String.class, this.baseContext.getCurrentUserId());
        this.strictInsertFill(metaObject, "createOrgId", String.class, this.baseContext.getCurrentOrgId());
        this.strictInsertFill(metaObject, "createTime", LocalDateTime.class, this.getSetterTypeOfLocal(metaObject, "createTime"));
    }

    public void updateFill(MetaObject metaObject) {
        this.logger.info("start update fill ....");
        this.strictUpdateFill(metaObject, "updateBy", String.class, this.baseContext.getCurrentUserId());
        this.setFieldValByName("updateTime", this.getSetterTypeOfLocal(metaObject, "updateTime"), metaObject);
    }

    private Object getSetterTypeOfLocal(MetaObject metaObject, String propertyName) {
        Class targetType = metaObject.getSetterType(propertyName);
        Comparable<ChronoLocalDateTime<?>> obj = null;
        if (LocalDateTime.class.equals((Object)targetType)) {
            obj = LocalDateTime.now();
        } else if (LocalDate.class.equals((Object)targetType)) {
            obj = LocalDate.now();
        } else if (Date.class.equals((Object)targetType)) {
            obj = new Date();
        }
        return obj;
    }
}

