package com.artfess.service.client;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.artfess.base.service.InvokeCmd;
import com.artfess.base.service.InvokeResult;
import com.artfess.base.service.ServiceClient;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.service.dao.ServiceSetDao;
import com.artfess.service.model.DefaultInvokeCmd;
import com.artfess.service.model.ServiceSet;
import com.artfess.service.util.ParamHandlerUtil;
import com.artfess.service.ws.WebServiceClient;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Map;

/**
 * 提供基于WebService的服务调用实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年7月3日
 */
@Primary
@Service
public class ServiceClientImpl implements ServiceClient{
	@Resource
	ServiceSetDao sysServiceSetDao;
	
	public InvokeResult invoke(InvokeCmd invokeCmd) {
		WebServiceClient webServiceClient = AppUtil.getBean(WebServiceClient.class);
		if("webservice".equals(invokeCmd.getType())){
			return webServiceClient.invoke(invokeCmd);
		}
		return null;
	}

	@Override
	public InvokeResult invoke(String alias, Map<String, Object> map) {
		ServiceSet serviceSet = sysServiceSetDao.getByAlias(alias);

		InvokeCmd invokeCmd = new DefaultInvokeCmd();
		invokeCmd.setAddress(serviceSet.getAddress());
		invokeCmd.setOperatorName(serviceSet.getMethodName());
		invokeCmd.setOperatorNamespace(serviceSet.getNamespace());
		invokeCmd.setNeedPrefix(serviceSet.getSoapAction()=='Y');

		String params;
		InvokeResult result = null;
		try {
			params = getJsonParam(map, serviceSet.getInputSet());
			invokeCmd.setJsonParam(params);
			result = this.invoke(invokeCmd);
		} catch (IOException e) {
			
		}
		return result;
	}

	/**
	 * 构建查询参数
	 * @param variables
	 * @param inputSet
	 * @return
	 * @throws IOException
	 */
	private String getJsonParam(Map<String, Object> variables,String inputSet) throws IOException{
		ArrayNode jsonElement = (ArrayNode) JsonUtil.toJsonNode(inputSet);
		ObjectNode jsonParamObj = JsonUtil.getMapper().createObjectNode();

		if(jsonElement.isArray()){
			ParamHandlerUtil.buildJsonParam(jsonElement,jsonParamObj,variables,ParamHandlerUtil.INPUT);
		}
		String ss = jsonParamObj.toString();
		return ss;
	}
}