package com.artfess.rabbitmq.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/** 消息投递到队列失败回调处理
 * @author 周渝森
 * @date 2020/8/24 10:17
 */
@Slf4j
public class RabbitMqReturnCallback implements RabbitTemplate.ReturnCallback {
    /**
     *
     * @param message 消息体
     * @param replyCode 响应Code
     * @param replyText 响应内容
     * @param exchange 交换机
     * @param routingKey 主题
     */
    @Override
    public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
        System.out.println("==message==" + message);
        System.out.println("ReturnCallback:     "+"消息："+message);
        System.out.println("ReturnCallback:     "+"响应码："+replyCode);
        System.out.println("ReturnCallback:     "+"响应信息："+replyText);
        System.out.println("ReturnCallback:     "+"交换机："+exchange);
        System.out.println("ReturnCallback:     "+"主题："+routingKey);
        log.info("returnedMessage==> 消息===>{},响应码===>{},响应信息===>{},交换机===>{},主题===>{}",message,replyCode,replyText,exchange,routingKey);
    }
}
