/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DateUtils;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfOperationSalesProductDManager;
import com.artfess.cqlt.manager.QfOperationSalesProductMManager;
import com.artfess.cqlt.model.QfOperationSalesProductD;
import com.artfess.cqlt.model.QfOperationSalesProductM;
import com.artfess.cqlt.vo.SalesProductDetailVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8fd0\u8425--\u4ea7\u54c1\u9500\u552e\u6570\u636e\u586b\u62a5\u4e3b\u8868"})
@RequestMapping(value={"/qf/operation/product/"})
@ApiGroup(group={"group_biz"})
public class QfOperationSalesProductMController
extends BaseController<QfOperationSalesProductMManager, QfOperationSalesProductM> {
    private static final Logger log = LoggerFactory.getLogger(QfOperationSalesProductMController.class);
    @Autowired
    private QfOperationSalesProductDManager operationSalesProductDManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) QfOperationSalesProductM t) {
        t.setFillUser(ContextUtil.getCurrentUserId());
        t.setFillDate(LocalDate.now());
        t.setFillQuarter(DateUtils.getQuarter((int)t.getFillMonth()));
        boolean result = ((QfOperationSalesProductMManager)this.baseService).insertInfo(t);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), (Object)t.getId());
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) QfOperationSalesProductM t) {
        boolean result = ((QfOperationSalesProductMManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PutMapping(value={"/updateStatus"})
    @ApiOperation(value="\u751f\u6548")
    public CommonResult<String> updateStatus(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody QfOperationSalesProductM t) {
        boolean result = ((QfOperationSalesProductMManager)this.baseService).updateStatus(t);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((QfOperationSalesProductMManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((QfOperationSalesProductMManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @ApiOperation(value="\u4ea7\u54c1\u9500\u552e\u6570\u636e\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="mainId", required=false) String mainId) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(QfOperationSalesProductD.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = ((QfOperationSalesProductMManager)this.baseService).importExcel(list, mainId);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"import.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/productDetail.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u4ea7\u54c1\u9500\u552e\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException(I18nUtil.getMessage((String)"resources.noexist", (Locale)LocaleContextHolder.getLocale()));
        }
    }

    @ApiOperation(value="\u4ea7\u54c1\u9500\u552e\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<QfOperationSalesProductD> queryFilter) throws Exception {
        PageList page = this.operationSalesProductDManager.query(queryFilter);
        ArrayList list = Lists.newArrayList();
        page.getRows().forEach(detail -> {
            SalesProductDetailVo detailVo = new SalesProductDetailVo();
            BeanUtil.copyProperties((Object)detail, (Object)((Object)detailVo), (String[])new String[0]);
            if (null != detail.getDeviationRate()) {
                detailVo.setDeviationRateStr(detail.getDeviationRate() + "%");
            }
            if (null != detail.getDeviationRateYtd()) {
                detailVo.setDeviationRateYtdStr(detail.getDeviationRateYtd() + "%");
            }
            list.add(detailVo);
        });
        ExcelUtils util = new ExcelUtils(SalesProductDetailVo.class);
        util.exportExcel(response, request, (List)list, "\u4ea7\u54c1\u9500\u552e\u6570\u636e\u4fe1\u606f");
    }
}

