/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.third.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.conf.DingdingConfig;
import com.artfess.base.dingding.utils.DingCallbackCrypto;
import com.artfess.base.model.CommonResult;
import com.artfess.third.service.DingdingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9489\u9489"})
@RequestMapping(value={"/api/dingding/"})
@ApiGroup(group={"device_biz"})
public class DingdingController {
    private static final Logger log = LoggerFactory.getLogger(DingdingController.class);
    @Autowired
    private DingdingService dingdingService;
    @Autowired
    private DingdingConfig dingdingConfig;

    @ApiOperation(value="\u83b7\u53d6\u9489\u9489\u914d\u7f6e\uff08\u4f01\u4e1aid\uff09")
    @GetMapping(value={"/config"})
    public CommonResult<String> getDingTalkConfig() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("corpId", this.dingdingConfig.getCorpId());
        return CommonResult.success(configMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @ApiOperation(value="\u9489\u9489\u4e8b\u4ef6\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/callBack"})
    public Map<String, String> callBack(@RequestParam(value="msg_signature", required=false) String msg_signature, @RequestParam(value="timestamp", required=false) String timeStamp, @RequestParam(value="nonce", required=false) String nonce, @RequestBody(required=false) JSONObject json) {
        try {
            log.info("------------------------");
            DingCallbackCrypto callbackCrypto = new DingCallbackCrypto(this.dingdingConfig.getToken(), this.dingdingConfig.getAeskey(), this.dingdingConfig.getAppKey());
            String encryptMsg = json.getString("encrypt");
            String decryptMsg = callbackCrypto.getDecryptMsg(msg_signature, timeStamp, nonce, encryptMsg);
            JSONObject eventJson = JSON.parseObject((String)decryptMsg);
            log.info("\u56de\u8c03\u4e8b\u4ef6\u54cd\u5e94\u6570\u636e:{}", (Object)eventJson);
            String eventType = eventJson.getString("EventType");
            if ("check_url".equals(eventType)) {
                log.info("\u6d4b\u8bd5\u56de\u8c03url\u7684\u6b63\u786e\u6027");
            } else if ("user_add_org".equals(eventType)) {
                log.info("\u53d1\u751f\u4e86\uff1a" + eventType + "\u4e8b\u4ef6");
            } else {
                log.info("\u53d1\u751f\u4e86\uff1a" + eventType + "\u4e8b\u4ef6");
            }
            Map successMap = callbackCrypto.getEncryptedMap("success");
            return successMap;
        }
        catch (DingCallbackCrypto.DingTalkEncryptException e) {
            e.printStackTrace();
            return null;
        }
    }
}

