/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.device.base.dao.DeviceProductInfoDao;
import com.artfess.device.base.dao.DeviceProductTypeDao;
import com.artfess.device.base.manager.DeviceProductTypeManager;
import com.artfess.device.base.model.DeviceProductType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceProductTypeManagerImpl
extends BaseManagerImpl<DeviceProductTypeDao, DeviceProductType>
implements DeviceProductTypeManager {
    @Resource
    private DeviceProductInfoDao productInfoDao;

    @Override
    public List<DeviceProductType> getTree(DeviceProductType entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)entity.getCode())) {
            queryWrapper.like((Object)"code_", (Object)entity.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
            queryWrapper.like((Object)"name_", (Object)entity.getName());
        }
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        queryWrapper.orderByDesc((Object)"sn_");
        List deviceAreaList = ((DeviceProductTypeDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        List tree = BeanUtils.listToTree((List)deviceAreaList);
        return tree;
    }

    @Override
    @Transactional
    public String updateProductType(DeviceProductType t) {
        DeviceProductType productType = (DeviceProductType)((Object)((DeviceProductTypeDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        String oldName = productType.getName();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"type_id_", (Object)productType.getId());
        List deviceProductInfos = this.productInfoDao.selectList((Wrapper)queryWrapper);
        deviceProductInfos.forEach(productInfo -> {
            productInfo.setFullName(productInfo.getFullName().replace(oldName, t.getName()));
            this.productInfoDao.updateById(productInfo);
        });
        return this.updateTree(t, oldName);
    }
}

