/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceInfoDao;
import com.artfess.device.base.dao.DeviceProductInfoDao;
import com.artfess.device.base.dao.DeviceProductTypeDao;
import com.artfess.device.base.manager.DeviceProductInfoManager;
import com.artfess.device.base.model.DeviceProductInfo;
import com.artfess.device.base.model.DeviceProductType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceProductInfoManagerImpl
extends BaseManagerImpl<DeviceProductInfoDao, DeviceProductInfo>
implements DeviceProductInfoManager {
    @Resource
    private DeviceProductTypeDao productTypeDao;
    @Resource
    private DeviceInfoDao deviceInfoDao;

    @Override
    @Transactional
    public String createInfo(DeviceProductInfo t) {
        int insert = ((DeviceProductInfoDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            DeviceProductType deviceProductType = (DeviceProductType)((Object)this.productTypeDao.selectById((Serializable)((Object)t.getTypeId())));
            if (null != deviceProductType) {
                t.setFullId(deviceProductType.getFullId() + "/" + t.getId());
                t.setFullName(deviceProductType.getFullName() + "/" + t.getName());
            }
            ((DeviceProductInfoDao)this.baseMapper).updateById((Object)t);
            return t.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public String updateInfo(DeviceProductInfo t) {
        DeviceProductType deviceProductType = (DeviceProductType)((Object)this.productTypeDao.selectById((Serializable)((Object)t.getTypeId())));
        if (null != deviceProductType) {
            t.setFullId(deviceProductType.getFullId() + "/" + t.getId());
            t.setFullName(deviceProductType.getFullName() + "/" + t.getName());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"product_id_", (Object)t.getId());
        List deviceInfos = this.deviceInfoDao.selectList((Wrapper)queryWrapper);
        deviceInfos.forEach(deviceInfo -> {
            deviceInfo.setFullName(t.getFullName() + "/" + deviceInfo.getName());
            this.deviceInfoDao.updateById(deviceInfo);
        });
        ((DeviceProductInfoDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    @Override
    public List<DeviceProductInfo> findAll(DeviceProductInfo productInfo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)productInfo.getCode())) {
            queryWrapper.like((Object)"code_", (Object)productInfo.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)productInfo.getName())) {
            queryWrapper.like((Object)"name_", (Object)productInfo.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)productInfo.getDeviceType())) {
            queryWrapper.like((Object)"device_type_", (Object)productInfo.getDeviceType());
        }
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        return ((DeviceProductInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }
}

