import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增防疫信息填写
  addDwdLkEpidemicPreventionInformation(data, cb) {
    req.post(portal + `/manager/dwdLkEpidemicPreventionInformation/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改防疫信息填写
  editDwdLkEpidemicPreventionInformation(data, cb) {
    req.put(portal + `/manager/dwdLkEpidemicPreventionInformation/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询防疫信息填写
  loadDwdLkEpidemicPreventionInformation(data, cb) {
    req.post(portal + `/manager/dwdLkEpidemicPreventionInformation/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除防疫信息填写
  deleteDwdLkEpidemicPreventionInformation(data, cb) {
    req.remove(portal + `/manager/dwdLkEpidemicPreventionInformation/delete`, data).then(res => {
      cb(res.data)
    })
  },

  // 导出
  export(data) {
    req.downloadPostCopy(portal + `/manager/dwdLkEpidemicPreventionInformation/export`, data).then(response => {
      const blob = new Blob([response.data], {
        type: 'application/vnd.ms-excel'
      })
      const fileName = Date.parse(new Date()) + '.xls'
      if (window.navigator.msSaveOrOpenBlob) {
        navigator.msSaveBlob(blob, fileName)
      } else {
        var link = document.createElement('a')
        link.href = window.URL.createObjectURL(blob)
        link.download = fileName
        link.click()
        // 释放内存
        window.URL.revokeObjectURL(link.href)
      }
    })
  }
}
