import req from "@/request.js";
const portal = window.context.portal;
export default {
	//水库概况
	resSituation(data, cb) {
		req.post(portal + '/biz/res/statistics/resSituation', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//测站概况
	stationSituation(data, cb) {
		req.post(portal + '/biz/res/statistics/stationSituation', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//超汛限柱状图
	superLimitedRank(cb) {
		req.post(portal + '/biz/warn/statistics/swWarning').then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//当年巡检排名
	statistical(data, cb) {
		req.post(portal + '/biz/res/statistics/statistical', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//最新巡检
	latestIns(id, cb) {
		req.post(portal + '/dsm/ins/result/insResultListNew?rscd=' + id).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//日雨量累计排行
	dayYlList(data, cb) {
		req.get(portal + '/biz/res/statistics/dayYlList?appType=' + data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//位移曲线图
	dammvList(data, cb) {
		req.post(portal + '/biz/res/statistics/dammvList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//监测预警 ===>获取水库水位、雨量站下拉列表
	findStList(data, cb) {
		req.post(portal + '/biz/res/statistics/findStList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//监测预警===> 视频站列表
	findVideoList(data, cb) {
		req.post(portal + '/biz/catalog/base/query', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//监测预警===> 位移站列表
	findDisplacementList(data, cb) {
		req.post(portal + '/biz/lift/monitor/dammvQuery', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//监测预警===> 渗压站列表
	findOsmosisList(data, cb) {
		req.post(portal + '/biz/lift/monitor/damopPage', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//水库详情
	resDetail(data, cb) {
		req.post(portal + '/biz/res/statistics/resDetail', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//根据水库编码获取预警信息
	getWarnInfo(data, cb) {
		req.get(portal + '/biz/res/statistics/getWarnInfo/' + data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//责任人列
	personList(data, cb) {
		req.get(portal + '/biz/res/statistics/personList/' + data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//水情监测
	rsvrLatestList(data, cb) {
		req.post(portal + '/biz/res/statistics/rsvrLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//雨情监测
	pptnLatestList(data, cb) {
		req.post(portal + '/biz/res/statistics/pptnLatestList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取监测站下拉
	monitoring(data, cb) {
		req.post(portal + '/biz/station/gq/findAll', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//渗压曲线图
	damspprList(data, cb) {
		req.post(portal + '/biz/res/statistics/damspprList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//水位关系曲线图
	lvtpcQuery(data, cb) {
		req.post(portal + '/wrp/rsr/lvtpc/query', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//当日水位雨情情况
	rsvrAndPptnValue(data, cb) {
		req.post(portal + '/biz/res/statistics/rsvrAndPptnValue', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//当日巡检水库
	insResult(data, cb) {
		req.post(portal + '/biz/res/statistics/insResult', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//当日巡检问题
	insQuestion(data, cb) {
		req.post(portal + '/biz/res/statistics/insQuestion', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取历史文化
	historyContent(data, cb) {
		req.get(portal + '/biz/res/statistics/getHistoryContent/' + data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//规程预案
	ddgcPlan(data, cb) {
		req.get(portal + '/biz/res/statistics/getDdgcPlan/' + data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//应急预案
	reservePlan(data, cb) {
		req.get(portal + '/biz/res/statistics/getReservePlan/' + data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//关联监控点列表
	videoList(data, cb) {
		req.post(portal + '/biz/res/statistics/getVideoList', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//获取位移、渗流、渗压下拉列表
	findGqStation(data, cb) {
		req.post(portal + '/biz/res/statistics/findGqStation', data).then(rep => {
			if (rep.data) {
				cb(rep.data);
			}
		});
	},
	//关闭预警
	updateStatus(data, cb) {
		req.post(portal + '/biz/warnInfo/updateStatus?ids=' + data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	//水库下拉列表
	findAll(data, cb) {
		req.post(portal + '/att/res/base/findAll', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	getDamspprList(data, cb) {
		req.post(portal + '/biz/monitor/curve/damspprList', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	/**
	 * 安全鉴定
	 */
	//分页列表
	ListGetSaf(data, cb) {
		req.post(portal + `/wrp/rsr/appraisal/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// PDF列表
	PdfListSaf(id, cb) {
		req.post(portal + `/biz/res/statistics/pdfList?rscd=` + id).then(rep => {
			cb(rep.data);
		});
	},


	/**
	 * 除险加固
	 */
	// 分页列表
	ListGetRes(data, cb) {
		req.post(portal + `/wrp/rsr/reinforce/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// ID查询PDF

	/**
	 * 维修保养
	 */
	// 分页列表
	ListGetMain(data, cb) {
		req.post(portal + `/wrp/rsr/maintain/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// ID查询PDF


}